% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nmcov.R
\name{read_nmcov}
\alias{read_nmcov}
\title{Read in the NONMEM variance-covariance matrix.}
\usage{
read_nmcov(fileName)
}
\arguments{
\item{fileName}{Root filename for the NONMEM run (e.g. "run315").

This function reads the ".cov" NONMEM output table, and will return an error if this
is missing.}
}
\value{
A symmetrical variance-covariance matrix covering all model parameters.
}
\description{
Read in the NONMEM variance-covariance matrix.
}
\examples{
\dontrun{
nmVcov <- read_nmcov("run315")
}
}
\seealso{
NONMEM (\url{http://www.iconplc.com/innovation/nonmem/})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
