% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.cv.glmnet.R
\name{pmml.cv.glmnet}
\alias{pmml.cv.glmnet}
\title{Generate the PMML representation for a cv.glmnet object from the package
\pkg{glmnet}.}
\usage{
\method{pmml}{cv.glmnet}(
  model,
  model_name = "Elasticnet_Model",
  app_name = "SoftwareAG PMML Generator",
  description = "Generalized Linear Regression Model",
  copyright = NULL,
  model_version = NULL,
  transforms = NULL,
  missing_value_replacement = NULL,
  dataset = NULL,
  s = NULL,
  ...
)
}
\arguments{
\item{model}{A cv.glmnet object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{model_version}{A string specifying the model version.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{dataset}{Data used to train the cv.glmnet model.}

\item{s}{'lambda' parameter at which to output the model. If not given, the
lambda.1se parameter from the model is used instead.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the cv.glmnet object.
}
\description{
Generate the PMML representation for a cv.glmnet object from the package
\pkg{glmnet}.
}
\details{
The \code{glmnet} package expects the input and predicted values in a matrix
format - not as arrays or data frames. As of now, it will also accept
numerical values only. As such, any string variables must be converted to
numerical ones. One possible way to do so is to use data transformation
functions from this package. However, the result is a data frame. In all
cases, lists, arrays and data frames can be converted to a matrix format
using the data.matrix function from the base package. Given a data frame df,
a matrix m can thus be created by using \code{m <- data.matrix(df)}.

The PMML language requires variable names which will be read in as the
column names of the input matrix. If the matrix does not have variable
names, they will be given the default values of "X1", "X2", ...

Currently, only \code{gaussian} and \code{poisson} family types are
supported.
}
\examples{
library(glmnet)

# Create a simple predictor (x) and response(y) matrices:
x <- matrix(rnorm(100 * 20), 100, 20)
y <- rnorm(100)

# Build a simple gaussian model:
model1 <- cv.glmnet(x, y)

# Output the model in PMML format:
model1_pmml <- pmml(model1)

# Shift y between 0 and 1 to create a poisson response:
y <- y - min(y)

# Give the predictor variables names (default values are V1,V2,...):
name <- NULL
for (i in 1:20) {
  name <- c(name, paste("variable", i, sep = ""))
}
colnames(x) <- name

# Create a simple poisson model:
model2 <- cv.glmnet(x, y, family = "poisson")

# Output the regression model in PMML format at the lambda
# parameter = 0.006:
model2_pmml <- pmml(model2, s = 0.006)
}
\references{
\href{https://CRAN.R-project.org/package=glmnet}{glmnet: Lasso and
elastic-net regularized generalized linear models (on CRAN)}
}
\author{
Tridivesh Jena
}
