% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pibble.R
\name{is_pibble}
\alias{is_pibble}
\title{Check whether an object has been declared as panel data}
\usage{
is_pibble(.df, .silent = FALSE)
}
\arguments{
\item{.df}{Data frame or tibble}

\item{.silent}{Set to TRUE to suppress output reporting what the panel identifiers are. Defaults to FALSE}
}
\description{
Checks whether a data set (\code{data.frame} or \code{tibble}) has been assigned panel identifiers in the \code{pmdplyr} format. If so, returns those identifiers.
}
\examples{

data(Scorecard)
Scorecard <- as_pibble(Scorecard, .i = "unitid", .t = "year")
is_pibble(Scorecard)
}
