% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmd.R
\name{globalstd}
\alias{globalstd}
\title{GlobalStd algorithm with structure/reaction directed analysis}
\usage{
globalstd(
  list,
  rtcutoff = 10,
  ng = 10,
  corcutoff = NULL,
  digits = 2,
  accuracy = 4,
  freqcutoff = NULL
)
}
\arguments{
\item{list}{a peaks list with mass to charge, retention time and intensity data}

\item{rtcutoff}{cutoff of the distances in cluster, default 10}

\item{ng}{cutoff of global PMD's retention time group numbers, default 10. If ng = NULL, 20 percent of RT cluster will be used as ng.}

\item{corcutoff}{cutoff of the correlation coefficient, default NULL}

\item{digits}{mass or mass to charge ratio accuracy for pmd, default 2}

\item{accuracy}{measured mass or mass to charge ratio in digits, default 4}

\item{freqcutoff}{pmd freqency cutoff for structures or reactions, default NULL. This cutoff will be found by PMD network analysis when it is NULL.}
}
\value{
list with GlobalStd algorithm processed data.
}
\description{
GlobalStd algorithm with structure/reaction directed analysis
}
\examples{
data(spmeinvivo)
re <- globalstd(spmeinvivo)
}
\seealso{
\code{\link{getpaired}},\code{\link{getstd}},\code{\link{getsda}},\code{\link{plotstd}},\code{\link{plotstdsda}},\code{\link{plotstdrt}}
}
