% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/petrinet.R
\name{petrinet_synchronous_product}
\alias{petrinet_synchronous_product}
\title{Synchronous product Petri net}
\usage{
petrinet_synchronous_product(pn1, im1, fm1, pn2, im2, fm2, skip = ">>",
  convert = TRUE)
}
\arguments{
\item{pn1}{First Petri net}

\item{im1}{Initial marking of the first Petri net}

\item{fm1}{Final marking of the first Petri net}

\item{pn2}{Second Petri net}

\item{im2}{Initial marking of the second Petri net}

\item{fm2}{Final marking of the second Petri net}

\item{skip}{Symbol to be used as skip}

\item{convert}{\code{TRUE} to automatically convert Python objects to their R equivalent. If you pass \code{FALSE} you can do manual conversion using the \link[reticulate]{r-py-conversion} function.}
}
\value{
A Petri net.
}
\description{
Constructs the synchronous product net of two given Petri nets.
}
\examples{
if (pm4py_available()) {
  library(eventdataR)
  data(patients)

  # As Inductive Miner of PM4PY is not life-cycle aware, keep only `complete` events:
  patients_completes <- patients[patients$registration_type == "complete", ]

  net <- discovery_inductive(patients_completes)
  petrinet_synchronous_product(net$petrinet,
                               net$initial_marking,
                               net$final_marking,
                               net$petrinet,
                               net$initial_marking,
                               net$final_marking)
}

}
