% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plume.R
\name{Plume}
\alias{Plume}
\title{Plume class}
\description{
Class that generates author lists and other author-related
information as character strings.
}
\examples{
# Create a Plume instance
aut <- Plume$new(encyclopedists)

# Set the desired corresponding authors, using
# authors' id by default
aut$set_corresponding_authors(1, 4)

# Getting authors suffixed by affiliation ids
# and the corresponding author mark:
aut$get_author_list("^a,c^")

# Or maybe with the corresponding author mark
# coming before affiliation ids:
aut$get_author_list("^c,a^")

# Getting more author metadata
aut$get_affiliations()

aut$get_contributions()

# Use `symbols` to change the default symbols.
# E.g. to use letters as affiliation ids:
aut <- Plume$new(
  encyclopedists,
  symbols = list(affiliation = letters)
)

aut$get_author_list("^a^")

aut$get_affiliations()

# It is also possible to output contributions in the
# active voice
aut <- Plume$new(encyclopedists, roles = c(
  supervision = "supervised the project",
  writing = "contributed to the Encyclopédie"
))
aut$get_contributions(roles_first = FALSE, divider = " ")
}
\section{Super classes}{
\code{\link[plume:NameHandler]{plume::NameHandler}} -> \code{\link[plume:PlumeHandler]{plume::PlumeHandler}} -> \code{\link[plume:StatusSetter]{plume::StatusSetter}} -> \code{\link[plume:StatusSetterPlume]{plume::StatusSetterPlume}} -> \code{Plume}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Plume-new}{\code{Plume$new()}}
\item \href{#method-Plume-get_author_list}{\code{Plume$get_author_list()}}
\item \href{#method-Plume-get_affiliations}{\code{Plume$get_affiliations()}}
\item \href{#method-Plume-get_notes}{\code{Plume$get_notes()}}
\item \href{#method-Plume-get_orcids}{\code{Plume$get_orcids()}}
\item \href{#method-Plume-get_contact_details}{\code{Plume$get_contact_details()}}
\item \href{#method-Plume-get_contributions}{\code{Plume$get_contributions()}}
\item \href{#method-Plume-clone}{\code{Plume$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="plume" data-topic="PlumeHandler" data-id="get_plume"><a href='../../plume/html/PlumeHandler.html#method-PlumeHandler-get_plume'><code>plume::PlumeHandler$get_plume()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plume" data-topic="PlumeHandler" data-id="get_roles"><a href='../../plume/html/PlumeHandler.html#method-PlumeHandler-get_roles'><code>plume::PlumeHandler$get_roles()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plume" data-topic="PlumeHandler" data-id="print"><a href='../../plume/html/PlumeHandler.html#method-PlumeHandler-print'><code>plume::PlumeHandler$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plume" data-topic="StatusSetter" data-id="set_corresponding_authors"><a href='../../plume/html/StatusSetter.html#method-StatusSetter-set_corresponding_authors'><code>plume::StatusSetter$set_corresponding_authors()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plume" data-topic="StatusSetterPlume" data-id="set_main_contributors"><a href='../../plume/html/StatusSetterPlume.html#method-StatusSetterPlume-set_main_contributors'><code>plume::StatusSetterPlume$set_main_contributors()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plume-new"></a>}}
\if{latex}{\out{\hypertarget{method-Plume-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{Plume} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plume$new(
  data,
  names = NULL,
  symbols = NULL,
  roles = credit_roles(),
  credit_roles = FALSE,
  initials_given_name = FALSE,
  family_name_first = FALSE,
  interword_spacing = TRUE,
  orcid_icon = orcid(),
  by = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing author-related data.}

\item{\code{names}}{A vector of key-value pairs specifying custom names to use,
where keys are default names and values their respective replacements.}

\item{\code{symbols}}{A list of key-value pairs defining the symbols to use to
link authors and their metadata. Valid keys are \code{"affiliation"},
\code{"corresponding"} and \code{"note"}. By default, uses digits for
affiliations, \code{"*"} for corresponding authors and \code{"†"}, \code{"‡"}, \code{"§"},
\code{"¶"}, \code{"#"}, \code{"**"} for notes. Set a key to \code{NULL} to use numerals.}

\item{\code{roles}}{A vector of key-value pairs defining roles where keys
identify role columns and values describe the actual roles to use.}

\item{\code{credit_roles}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

It is now recommended to use \code{roles = credit_roles()} to use the
\href{https://credit.niso.org}{Contributor Roles Taxonomy}.}

\item{\code{initials_given_name}}{Should the initials of given names be used?}

\item{\code{family_name_first}}{Should literal names show family names first?}

\item{\code{interword_spacing}}{Should literal names use spacing? This parameter
is only useful for people writing in languages that don't separate
words with a space such as Chinese or Japanese.}

\item{\code{orcid_icon}}{The ORCID icon, as defined by \code{\link[=orcid]{orcid()}}, to be used.}

\item{\code{by}}{A character string defining the default variable used to assign
specific metadata to authors in all \verb{set_*()} methods. By default, uses
authors' id.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Plume} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plume-get_author_list"></a>}}
\if{latex}{\out{\hypertarget{method-Plume-get_author_list}{}}}
\subsection{Method \code{get_author_list()}}{
Get author list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plume$get_author_list(suffix = NULL, format = deprecated())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{suffix}}{A character string defining the format of symbols suffixing
author names. See details.}

\item{\code{format}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Please use the parameter \code{suffix} instead.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\code{suffix} lets you choose which symbol categories to suffix authors with,
using the following keys:
\itemize{
\item \code{a} for affiliations
\item \code{c} for corresponding authors
\item \code{n} for notes
\item \code{o} for ORCIDs
}

The order of the keys determines the order of symbol types. E.g. \code{"ac"}
shows affiliation ids first and corresponding author mark second, when
\code{"ca"} shows corresponding author mark first and affiliation ids second.
Use \code{","} to separate and \code{"^"} to superscript symbols.
Use \code{NULL} or an empty string to list author names without suffixes.
}

\subsection{Returns}{
A character vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plume-get_affiliations"></a>}}
\if{latex}{\out{\hypertarget{method-Plume-get_affiliations}{}}}
\subsection{Method \code{get_affiliations()}}{
Get authors' affiliations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plume$get_affiliations(sep = "", superscript = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sep}}{Separator used to separate affiliation ids and affiliations.}

\item{\code{superscript}}{Should affiliation ids be superscripted?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plume-get_notes"></a>}}
\if{latex}{\out{\hypertarget{method-Plume-get_notes}{}}}
\subsection{Method \code{get_notes()}}{
Get authors' notes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plume$get_notes(sep = "", superscript = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sep}}{Separator used to separate note ids and notes.}

\item{\code{superscript}}{Should note ids be superscripted?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plume-get_orcids"></a>}}
\if{latex}{\out{\hypertarget{method-Plume-get_orcids}{}}}
\subsection{Method \code{get_orcids()}}{
Get authors' ORCID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plume$get_orcids(compact = FALSE, icon = TRUE, sep = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{compact}}{Should links only display the 16-digit identifier?}

\item{\code{icon}}{Should the ORCID icon be shown?}

\item{\code{sep}}{Separator used to separate authors and their respective ORCID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plume-get_contact_details"></a>}}
\if{latex}{\out{\hypertarget{method-Plume-get_contact_details}{}}}
\subsection{Method \code{get_contact_details()}}{
Get the contact details of corresponding authors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plume$get_contact_details(
  format = "{details} ({name})",
  email = TRUE,
  phone = FALSE,
  fax = FALSE,
  url = FALSE,
  sep = ", "
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{A \code{\link[glue:glue]{glue}} specification that uses the
variables \code{name} and/or \code{details}.}

\item{\code{email, phone, fax, url}}{Arguments equal to \code{TRUE} are evaluated and
passed to the variable \code{details}. By default, only \code{email} is set to
\code{TRUE}.}

\item{\code{sep}}{Separator used to separate \code{details} items.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plume-get_contributions"></a>}}
\if{latex}{\out{\hypertarget{method-Plume-get_contributions}{}}}
\subsection{Method \code{get_contributions()}}{
Get authors' contributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plume$get_contributions(
  roles_first = TRUE,
  by_author = FALSE,
  alphabetical_order = FALSE,
  dotted_initials = TRUE,
  literal_names = FALSE,
  divider = ": ",
  sep = ", ",
  sep_last = " and "
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{roles_first}}{If \code{TRUE}, displays roles first and authors second. If
\code{FALSE}, roles follow authors.}

\item{\code{by_author}}{Should roles be grouped by author?}

\item{\code{alphabetical_order}}{Should authors be listed in alphabetical order?
By default, lists authors in the order they are defined in the data.}

\item{\code{dotted_initials}}{Should initials be dot-separated?}

\item{\code{literal_names}}{Should literal names be used?}

\item{\code{divider}}{Separator used to separate roles and authors. Uses \code{": "}
by default.}

\item{\code{sep}}{Separator used to separate roles or authors.}

\item{\code{sep_last}}{Separator used to separate the last two roles or authors
if more than one item is associated to a role or author.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plume-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Plume-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plume$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
