% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_capital.R
\name{capitalize}
\alias{capitalize}
\alias{is_capital}
\alias{is_capitalized}
\title{Capitalization}
\usage{
capitalize(x)

is_capital(x, strict = FALSE)

is_capitalized(x, strict = FALSE)
}
\arguments{
\item{x}{A character vector.}

\item{strict}{If strict is \code{TRUE}, \code{is_capital()} and \code{is_capitalized()}
return \code{FALSE} instead of \code{NA} when characters are neither capital nor
lowercase.
Defualts to \code{FALSE}.}
}
\value{
\code{capitalize()} returns a character vector of the same length as \code{x}.

\code{is_capital()} and \code{is_capitalized()} return a logical vector of the same
length as \code{x}.
}
\description{
\code{capitalize()} returns a character vector \code{x} with the first
alphabetic character replaced with a capital form (if one exists).
}
\details{
\code{is_capital()} returns \code{\link{TRUE}} if all characters are capital, \code{\link{FALSE}} if
all characters are lowercase, and \code{\link{NA}} if characters are mixed case or any
characters are caseless (e.g. numbers, punctuation marks, characters from a
unicase language like Arabic, Chinese or Hindi).

\code{is_capitalized()} returns \code{\link{TRUE}} if the first alphabetic character in a
string is capital, \code{\link{FALSE}} if the first alphabetic character is lowercase,
and \code{\link{NA}} if there are no alphabetic characters or the first alphabetic
character is caseless (i.e. from a unicase language like Arabic, Chinese
or Hindi).
}
\examples{
capitalize(c("word", "a whole phrase"))
capitalize("preserving MIXED Case")
capitalize("... word")

is_capital(c("a", "A", "!"))
is_capital(c("aa", "AA", "!!"))
is_capital("Aa")

is_capitalized(c("a word", "A word", "a Word"))
is_capitalized("... A word")
is_capitalized("...")
}
