\name{analyticsPolyLeg}
\alias{analyticsPolyLeg}
\title{
Simulate a Dataset and Calculate Legendre Polynomials
}
\description{
  This function simulates a LHS and calculates the
  Legendre polynomials, optionally reducted
  to the most significant monomials.
  
  The  inputs are generated by  the function
  \code{\link[lhs:randomLHS]{randomLHS}} (from package
  \code{\link[lhs:lhs-package]{lhs}}). Note that they are
  uniformly and independently sampled.
  The output is calculated by using 
  the  \code{Ishigami} [Saltelli, 2000, Chap. 2]
  or \code{Sobol} [Sobol', 2003] functions.
   Legendre polynomials are then computed
  after calibration within the bounds [-1, +1].
}
\usage{
analyticsPolyLeg(nlhs, degree, model.fun, forward=NULL)
}
\arguments{
  \item{nlhs}{integer equal to the number of rows of the dataset.
  }
  \item{degree}{
    integer equal to the degree of the polynomial.
    Should be greater than 1 and less than 11.
}
  \item{model.fun}{
    string equal to the required model. Valid values are
    \code{'ishigami'} and \code{'sobol'}.
  }
  \item{forward}{
    NULL or an integer equal to the required number of monomials.
    A null value (the default), or a value less than the number of
    inputs or greater than
    the total number of monomials, means that all the monomials are kept. See details.}
}
\note{
The returned values are dependent on the random seed.
}
\value{
  An objet of class \code{\linkS4class{PCEpoly}}.
}
\details{
  \itemize{ 
  \item
  The Ishigami function has three inputs that
are linked to the output \code{Y} according to:

\deqn{Y=sin(X_1)+7*(sin(X_2))^2+0.1*(X_3)^4*sin(X_1)}{
  Y=sin(X1)+7*(sin(X2))^2+0.1*(X3)^4*sin(X1)}

 Each \eqn{X_j}{Xj}  is a uniform random variable on the interval
[\eqn{-\pi, + \pi}{-pi, +pi}].
\item
The Sobol  function has height inputs.
The four first ones only are generated by using the function
\code{\link[lhs:randomLHS]{randomLHS}}.
The four last are set to 0.5 (see Gauchi, 2016).
The output \code{Y} is then the product of :

\deqn{(4*X_j - 2 + A_j) / (1+A_j)}{
      (4*Xj - 2 + Aj) / (1+Aj)}

    for \eqn{j} in 1 to 8, and \eqn{A=(1,2,5,10,20,50,100,500)}
    \item
    When the value of the argument \code{forward} is non NULL,
    it should be an integer equal to the required
    number of the monomials (let say \code{q}). The \code{q} monomials are selected,
    among all the monomials of the full polynomial, by all the
    linear simple regressions of the output versus all the monomials.
    Those associated with the \code{q} largest \eqn{R^2}{R^2} values
    are kept.
    
}
}


\references{
\itemize{ 
  \item Ishigami, T. and Homma, T. 1990. An importance quantification technique in uncertainty analysis for computer models. In \emph{Proceedings of the First
International Symposium on Uncertainty Modeling and Analysis}. IEEE,
398-403.
\item Sobol', I.M., 2003. Theorems and examples on high dimensional model
representation. In \emph{Reliability Engineering \& System Safety}
79, 187-193.
}
}

\seealso{
\itemize{ 
  \item   Function \code{\link{polyLeg}}  calculates
  Legendre polynomials on a user dataset.
  \item Function \code{\link{calcPLSPCE}} calculates PLS-PCE sensivity indexes
from the returned
  object.
  }
}
\examples{
nlhs <- 200 # number of rows in the dataset
degree <- 6 # polynomial degree
set.seed(42) # fix the seed for reproductible results
### Data simulation and creation of the full polynomials
pce <- analyticsPolyLeg(nlhs, degree, 'ishigami') 
print(pce)
### Selection of the 50 most significant monomials
pcef <- analyticsPolyLeg(nlhs, degree, 'ishigami', forward=50)
print(pcef)
}
\keyword{ regression }