% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{config}
\alias{config}
\title{Set the default configuration for plotly}
\usage{
config(
  p,
  ...,
  cloud = FALSE,
  showSendToCloud = cloud,
  locale = NULL,
  mathjax = NULL
)
}
\arguments{
\item{p}{a plotly object}

\item{...}{these arguments are documented at
\url{https://github.com/plotly/plotly.js/blob/master/src/plot_api/plot_config.js}}

\item{cloud}{deprecated. Use \code{showSendToCloud} instead.}

\item{showSendToCloud}{include the send data to cloud button?}

\item{locale}{locale to use. See \href{https://github.com/plotly/plotly.js/tree/master/dist#to-include-localization}{here} for more info.}

\item{mathjax}{add \href{https://github.com/plotly/plotly.js/tree/master/dist#to-support-mathjax}{MathJax rendering support}.
If \code{"cdn"}, mathjax is loaded externally (meaning an internet connection is needed for
TeX rendering). If \code{"local"}, the PLOTLY_MATHJAX_PATH environment variable must be
set to the location (a local file path) of MathJax. IMPORTANT: \strong{plotly} uses SVG-based
mathjax rendering which doesn't play nicely with HTML-based rendering
(e.g., \strong{rmarkdown} documents and \strong{shiny} apps). To leverage both types of rendering,
you must \verb{<iframe>} your plotly graph(s) into the larger document
(see \href{https://github.com/ropensci/plotly/blob/master/inst/examples/rmd/MathJax/index.Rmd}{here}
for an \strong{rmarkdown} example and
\href{https://github.com/ropensci/plotly/blob/master/inst/examples/rmd/MathJax/index.Rmd}{here} for a \strong{shiny} example).}
}
\description{
Set the default configuration for plotly
}
\examples{

# remove the plotly logo and collaborate button from modebar
config(plot_ly(), displaylogo = FALSE, collaborate = FALSE)

# enable mathjax
# see more examples at https://plotly.com/r/LaTeX/
plot_ly(x = c(1, 2, 3, 4), y = c(1, 4, 9, 16)) \%>\%
  layout(title = TeX("\\\\text{Some mathjax: }\\\\alpha+\\\\beta x")) \%>\%
  config(mathjax = "cdn")

# change the language used to render date axes and on-graph text 
# (e.g., modebar buttons)
today <- Sys.Date()
x <- seq.Date(today, today + 360, by = "day")
p <- plot_ly(x = x, y = rnorm(length(x))) \%>\%
  add_lines()

# japanese
config(p, locale = "ja")
# german
config(p, locale = "de")
# spanish
config(p, locale = "es")
# chinese
config(p, locale = "zh-CN")

}
\author{
Carson Sievert
}
