% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ggplot.R
\name{add_ggplot}
\alias{add_ggplot}
\title{Add ggplot2 elements to a plotdap object}
\usage{
add_ggplot(plot, ...)
}
\arguments{
\item{plot}{a plotdap object.}

\item{...}{arguments passed along to \code{geom_sf()}
(if \code{method='ggplot2'}, otherwise ignored).}
}
\value{
A plotdap object
}
\description{
\code{add_ggplot} allows for plotdap ggplot maps to be modified by
further ggplot2 settings
}
\examples{

library(ggplot2)

add_ggplot(
 plotdap(
   crs = "+proj=laea +y_0=0 +lon_0=155 +lat_0=-90 +ellps=WGS84 +no_defs",
   mapColor = "black"
 ),
 theme_bw()
)


}
