% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik.R
\name{log_lik}
\alias{log_lik}
\title{Evaluate the negative log-likelihood of an intercept-only Gaussian plmm model}
\usage{
log_lik(eta, n, s, U, y, rot_y = NULL)
}
\arguments{
\item{eta}{The proportion of variance in the outcome that is attributable to causal SNP effects. In other words, signal-to-noise ratio.}

\item{n}{The number of observations}

\item{s}{The singular values of K, the realized relationship matrix}

\item{U}{The left-singular vectors of the \emph{standardized} design matrix}

\item{y}{Continuous outcome vector.}

\item{rot_y}{Optional: if y has already been rotated, then this can be supplied.}
}
\value{
the value of the log-likelihood of the PLMM, evaluated with the supplied parameters
}
\description{
This function allows you to evaluate the negative log-likelihood of a linear mixed model under the assumption of a null model in order to estimate the variance parameter, eta.
}
\keyword{internal}
