% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_ranfixef.R
\name{within_intercept}
\alias{within_intercept}
\alias{within_intercept.plm}
\title{Overall Intercept for Within Models Along its Standard Error}
\usage{
within_intercept(object, ...)

\method{within_intercept}{plm}(object, vcov = NULL, ...)
}
\arguments{
\item{object}{object of class \code{plm} which must be a within
model (fixed effects model),}

\item{\dots}{further arguments (currently none).}

\item{vcov}{if not \code{NULL} (default), a function to calculate a
user defined variance--covariance matrix (function for robust
vcov),}
}
\value{
A named \code{numeric} of length one: The overall intercept
for the estimated within model along attribute "se" which
contains the standard error for the intercept.
}
\description{
This function gives an overall intercept for within models and its
accompanying standard error
}
\details{
The (somewhat artificial) intercept for within models (fixed
effects models) was made popular by Stata of StataCorp
\insertCite{@see @GOUL:13}{plm}, EViews of IHS, and gretl
\insertCite{@gretl p. 160-161, example 18.1}{plm}, see for
treatment in the literature,
e.g. \insertCite{GREE:12;textual}{plm}, Ch. 11.4.4, p. 364. It can
be considered an overall intercept in the within model framework
and is the weighted mean of fixed effects (see \strong{Examples} for the
relationship).

\code{within_intercept} estimates a new model which is
computationally more demanding than just taking the weighted
mean. However, with \code{within_intercept} one also gets the
associated standard error and it is possible to get an overall
intercept for twoway fixed effect models.

Users can set argument \code{vcov} to a function to calculate a
specific (robust) variance--covariance matrix and get the
respective (robust) standard error for the overall intercept,
e.g. the function \code{\link[=vcovHC]{vcovHC()}}, see examples for
usage. Note: The argument \code{vcov} must be a function, not a
matrix, because the model to calculate the overall intercept for
the within model is different from the within model itself.
}
\examples{

# TODO: two-way unbalanced case, once fixef() produces results that
# are compatible estimate within model (unbalanced data)
data("Hedonic", package = "plm")
mod_fe <- plm(mv ~ age + crim, data = Hedonic, index = "townid")
overallint <- within_intercept(mod_fe)
attr(overallint, "se") # standard error

# overall intercept is the weighted mean of fixed effects in the
# one-way case
weighted.mean(fixef(mod_fe), as.numeric(table(index(mod_fe)[[1]])))

# relationship of type="dmean", "level" and within_intercept in the
# one-way case
data("Grunfeld", package = "plm")
gi <- plm(inv ~ value + capital, data = Grunfeld, model = "within")
fx_level <- fixef(gi, type = "level")
fx_dmean <- fixef(gi, type = "dmean")
overallint <- within_intercept(gi)
all.equal(overallint + fx_dmean, fx_level, check.attributes = FALSE) # TRUE

# overall intercept with robust standard error
within_intercept(gi, vcov = function(x) vcovHC(x, method="arellano", type="HC0"))

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=fixef]{fixef()}} to extract the fixed effects of a
within model.
}
\author{
Kevin Tappe
}
\keyword{attribute}
