% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_index}
\alias{mosaic_index}
\title{Mosaic Index}
\usage{
mosaic_index(mosaic, index = "R", r = 3, g = 2, b = 1, re = 4, nir = 5)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{index}{The index to use for the index view. Defaults to "B".}

\item{r}{The layer for the Red band (default: 3).}

\item{g}{The layer for the Green band (default: 2).}

\item{b}{The layer for the Blue band (default: 1).}

\item{re}{The layer for the Red-edge band (default: 4).}

\item{nir}{The layer for the Near-infrared band(default: 5).}
}
\value{
An index layer extracted/computed from the mosaic raster.
}
\description{
Compute or extract an index layer from a multi-band mosaic raster.
}
\details{
This function computes or extracts an index layer from the input
mosaic raster based on the specified index name. If the index is not found
in the package's predefined index list (see \code{\link[=image_index]{image_index()}} for more
details), it attempts to compute the index using the specified band
indices. The resulting index layer is returned as an \code{SpatRaster} object.
}
\examples{
library(pliman)
library(terra)
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))
confusion <-
     matrix(rnorm(90*95, 100, 30),
            nrow = nrow(mosaic),
            ncol = ncol(mosaic))
confusion <- mosaic_input(confusion)
terra::ext(confusion) <- terra::ext(mosaic)
terra::crs(confusion) <- terra::crs(mosaic)
names(confusion) <- "confusion"
two_layers <- c(mosaic, confusion)
final <- mosaic_index(two_layers, "B+R", b = 1, r = 2)
mosaic_view(mosaic_input(final), viewer = "base")

}
