% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shp.R
\name{object_map}
\alias{object_map}
\title{Map Object Distances}
\usage{
object_map(object, by_column = "img", direction = c("horizontal", "vertical"))
}
\arguments{
\item{object}{An \code{anal_obj} object computed with \code{analyze_objects_shp()}.}

\item{by_column}{The column name in the object's results data frame to group
objects by. Default is "img".}

\item{direction}{The direction of mapping. Should be one of "horizontal" or
"vertical". Default is "horizontal".}
}
\value{
A list with the following components:
\item{distances}{A list of distances between objects grouped by unique values
in the specified column/row.}
\item{cvs}{A vector of coefficient of variation (CV) values for each column/row.}
\item{means}{A vector of mean distances for each column/row.}
}
\description{
Computes distances between objects in an \code{anal_obj} object and returns a list
of distances, coefficient of variation (CV), and means.
}
\examples{
if(interactive()){
library(pliman)
flax <- image_pliman("flax_leaves.jpg", plot =TRUE)
res <-
   analyze_objects_shp(flax,
                       nrow = 3,
                       ncol = 1,
                       watershed = FALSE,
                       index = "R/(G/B)",
                       plot = FALSE)
plot(res$final_image_mask)
plot(res$shapefiles)

# distance from each leave within each row
result <- object_map(res)
result$distances
result$cvs
result$means
}
}
\seealso{
\code{\link{analyze_objects_shp}}
}
