% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_pipe.R
\name{pipe}
\alias{pipe}
\alias{\%>\%}
\title{Forward-pipe operator}
\usage{
lhs \%>\% rhs
}
\arguments{
\item{lhs}{The result you are piping.}

\item{rhs}{Where you are piping the result to.}
}
\description{
Pipe an object forward into a function or call expression.
}
\examples{
library(pliman)

# Basic use:
 iris \%>\% head()

# use to apply several functions to an image
img <- image_pliman("la_leaves.jpg")

img \%>\%
 image_resize(50) \%>\%        # resize to 50\% of the original size
 object_isolate(id = 1) \%>\%  # isolate object 1
 image_filter() \%>\%          # apply a median filter
 plot()                      # plot

}
\author{
Nathan Eastwood \email{nathan.eastwood@icloud.com} and Antoine Fabri
\email{antoine.fabri@gmail.com}. The code was obtained from poorman package
at \url{https://github.com/nathaneastwood/poorman/blob/master/R/pipe.R}
}
