\name{plsmooth}
\alias{plsmooth}
\alias{plsmoothline}
\alias{plrefline}

\title{Smooth and Reference Line Plotting}

\description{
  These functions add smooths or reference lines to an existing pl plot.
}
\usage{
plsmooth(x = NULL, y = NULL, ysec = NULL, band=NULL, power = NULL,
  group = NULL, weight = NULL, smooth = TRUE,
  plargs = NULL, ploptions = NULL, xy = TRUE, ...)

plsmoothline(smoothline = NULL, x = NULL, y = NULL, ysec = NULL,
  smooth.col = NULL, smooth.lty = NULL, smooth.lwd = NULL, 
  plargs = NULL, ploptions = NULL, marpar = NULL, ...)

plrefline(refline, x=NULL, innerrange=NULL, y=NULL,
  cutrange = c(x = TRUE, y = FALSE), plargs=NULL, ploptions=NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x, y}{coordinates for the horizontal and veritical axis,
    respectively. If \code{NULL}, they will be retrieved from
    \code{plargs$pldata}.
  }
  \item{ysec}{for \code{plsmooth, plsmoothline}:
    matrix of secondary y values. The smooths generated or given by its
    columns will be drawn thinner and with paled color.
  }
  \item{band}{logical: should a band (e.g., a confidence band)
    be drawn together with the smooth?
  }
  \item{power}{for \code{plsmooth}: smooth will be calcutated for
    \code{y^power} and the back-transformed. Usually, \code{power=0}.
  }
  \item{group}{for \code{plsmooth}: grouping variable.
    If \code{NULL}, the variable \code{.smooth.group.} column in
    \code{plargs$pldata} will be used if available.
    If \code{group} is of length 1, there will be no grouping
  }
  \item{weight}{weights of observations used for generating the smooth}
  \item{smooth}{logical: should smooth be done? Will almost always be
    \code{TRUE}}
  \item{smoothline}{for \code{plsmoothline}: result of a smooth fitting}
  \item{smooth.col, smooth.lty, smooth.lwd}{for \code{plsmoothline}:
    color, line type and line width for the smooth line(s).
    By default, they will be taken from ploptions.
  }
  \item{refline}{for \code{plrefline}:
    A two element vector giving intercept and slope of a straight line, 
    or a function that returns these as the first 2 elemnts of the
    result's \code{coef} component, such as \code{lm}.
    For more possibilities, see Details.
  }
  \item{innerrange}{for \code{plrefline}: inner range in x direction -
    only needed if the refline should be clipped at a range different
    from the \code{innerrange} attribute of the horizontal variable}
  \item{cutrange}{for \code{plrefline}: logical vector of length 2:
    should the reference line(s) be cut at the inner plotting ranges in
    x- and y-direction?
    Otherwise, it will be continued outside it with the appropriate
    transformation.
  }
  \item{plargs, ploptions}{result of \code{\link{pl.control}}, see Details
  }
  \item{marpar}{margin parameters, if already available.
    By default, they will be retieved from \code{ploptions}.
  }
  \item{xy}{logical: should the coordinates be obtained as in
    high level graphics? This is set to \code{FALSE} to save time and
    avoid complications, in case the user is sure that \code{x} and
    \code{y} are vectors rather than formulas or variable names.
  }
  \item{\dots}{absorbs extra arguments}
}
\value{
  \code{plsmooth} invisibly returns the data.frame needed for
  drawing the smooth line. The other functions return \code{NULL}
}
\details{
  The argument \code{refline} accepts different types of values.
  If it is a function, it must either accept a formula
  (which will be \code{y~x}) as its first argument or
  \code{x} and \code{y} as the first two arguments.\cr
  Alternatively, \code{refline} can be
  a list with components \code{x} and \code{y}
  and possibly a component \code{band} that contains the coordinates
  of the line (or lines, if \code{y} is a matrix) and the width of
  a band around it (that is, additional lines, to be drawn with
  \code{ploptions("refline.col")[2]}).\cr
  In order to obtain more than one reference line, a list of such
  items may be given. It should not have compontents named
  \code{coef, coefficients, x} or \code{y}, since it would otherwise
  be mistaken for an argument of the types just described.
  The components may carry attributes \code{lty, lwd} and \code{lcol}
  to specify the properties of the lines individually. See Examples.

  \code{plsmooth} and \code{plrefline} are very similar.
  They are both called by high level pl functions.
  \code{plsmooth} gets its smoothing function from
  \code{ploptions("smooth.function")}.
  Their properties (line type, width, color) come from different
  sets of pl options. \code{plsmooth} can also respect a group
  structure in the data.

  If \code{x} or \code{y} has an attribute \code{"numvalues"},
  these are used as the values to calculate the smooth or the
  refline.
  
  \code{plargs} and \code{ploptions} may be specified explicitly,
  but they are usually generated by calling \code{pl.control}.

  The argument \code{getpar} is used for setting the graphical
  parameters \code{mar, mgp} according to \code{ploptions}?
  This is needed if the high level pl function has changed \code{mar},
  since this change has been reversed when the function was left.
  By default, these graphical parameters will be retieved from
  \code{pl.envir$ploptions}.
}
  
\author{Werner A. Stahel
}

\seealso{\link{pl.control}
}
\examples{
plyx(Sepal.Width ~ Sepal.Length, data=iris, smooth=TRUE,
  smooth.group=Species, pch=Species)
plsmooth(smooth.group=FALSE)

## plrefline  called from  plyx
plyx(Sepal.Width ~ Sepal.Length, data=iris, smooth=TRUE, pch=Species,
     smooth.group=iris$Species, refline=lm)
## more reference lines
plrefline(list(c(-2,1), structure(c(-2.3,1), lcol="purple", lty=1)))
}

\keyword{aplot}

