% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_rasch.R
\name{fit.rasch}
\alias{fit.rasch}
\title{Fits an LMA using fixed category scores}
\usage{
fit.rasch(
  Master,
  npersons,
  nitems,
  ncat,
  nless,
  Maxnphi,
  pq.mat,
  starting.sv,
  LambdaNames,
  PhiNames,
  ItemNames,
  LambdaName,
  ntraits
)
}
\arguments{
\item{Master}{Master data set in long format}

\item{npersons}{Number of persons}

\item{nitems}{Number of items}

\item{ncat}{Number of categories}

\item{nless}{Number of unique Lambdas (i.e., ncat-1)}

\item{Maxnphi}{Number of phi parameters}

\item{pq.mat}{One dimensional array to compute rest-scores}

\item{starting.sv}{Fixed category scores}

\item{LambdaNames}{Names of lambda paramters in Master and formula
for stacked regression}

\item{PhiNames}{Names of association parameters}

\item{ItemNames}{Names of items}

\item{LambdaName}{Names of lambdas used in output}

\item{ntraits}{Number of traits}
}
\value{
estimates 	  An item by parameter matrix of the maximum of the log likelihood,
                       estimated item parameters (i.e., Lambdas), and the values of
                       the fixed category scores.

fstack	    	Formula for stacked regression

phi.mlogit	Results from mlogit for stacked regression

estimates    An item x parameter estimate matrix and fixed category scores used

Phi.mat      Estimated phi parameters

mlpl.phi     Value of maximum of log pseudo-likelihood function from the stacked regression

AIC          Akaike information criterion for pseudo-likelihood (smaller is better)

BIC          Bayesian information criterion for pseudo-likelihood (smaller is better)
}
\description{
The LMA model with fixed category scores is fit by this function and
the model corresponds to models in the Rasch family of item response
models.  The category scores can be set by either the user or the
package defaults. The default category scores are equally spaced, sum to
zero, and sum of squares equal 1. Scores can be set by user by
specifying them in the item by category matrix of 'starting.sv'.  The
pseudo-likelihood algorithm only runs a single stacked regression.
This functionis called from' ple.lma' but can also be run outside
of the main wrapper function.
}
\examples{
 #---  data(dass)
 inData <- dass[1:250,c("d1", "d2", "d3", "a1","a2","a3","s1","s2","s3")]
 #--- unidimensional
 inTraitAdj  <- matrix(1, nrow=1, ncol=1)
 inItemTraitAdj <- matrix(1, nrow=9, ncol=1)

 s <- set.up(inData, model.type='rasch', inTraitAdj, inItemTraitAdj)

 r <- fit.rasch(s$Master, s$npersons, s$nitems, s$ncat, s$nless, s$Maxnphi,
          s$pq.mat, s$starting.sv, s$LambdaNames, s$PhiNames, s$ItemNames,
          s$LambdaName, s$ntraits)

}
