% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScaleGPCM.R
\name{ScaleGPCM}
\alias{ScaleGPCM}
\title{Imposes scaling constraint to identify parameters of LMA (GPCM)}
\usage{
ScaleGPCM(
  Master,
  item.log,
  Phi.mat,
  PersonByItem,
  npersons,
  nitems,
  ncat,
  nless,
  ntraits,
  starting.sv,
  item.by.trait
)
}
\arguments{
\item{Master}{Master/main data set}

\item{item.log}{Iteration history array, last row are current parameters}

\item{Phi.mat}{Current phi matrix}

\item{PersonByItem}{inData (response patterns)}

\item{npersons}{Number of persons}

\item{nitems}{Number of items}

\item{ncat}{Number of categories}

\item{nless}{Number of unique lambdas (ncat-1)}

\item{ntraits}{Number of latent traits}

\item{starting.sv}{Matrix of fixed category scores (nitems x ncat)}

\item{item.by.trait}{Object that indicates which trait item loads on}
}
\value{
Master   Master data set with re-scaled scale values

Phi.mat	 Re-scaled matrix of association parameters
}
\description{
Scaling is internal to the function 'fit.gpcm', which fits the GPCM
version of the LMA. It imposes the required scaling identification
constraint by transforming the conditional covariance matrix 'Phi.mat' to a
conditional correlation matrix. The inverse transformation is applied to the
current estimates of the slope or 'a' parameters. Category scale values are
recomputed using the re-scale slopes (i.e., nu= a*x) and these are put back
into the Master data set so that data are ready for the next iteration of the
algorithm.
}
