% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_map.R
\name{read_map}
\alias{read_map}
\title{Annotates dataframe with metadata in a platemap matrix}
\usage{
read_map(data, map, verbose = TRUE, new_col_name = "header")
}
\arguments{
\item{data}{existing daatframe, with wellIDs under the column name of 'well'}

\item{map}{Matrix of metadata to be added to the dataframe, N.B NO MISSING WELLS!}

\item{verbose}{Boolean, if TRUE will add row and column numbers to dataframe}

\item{new_col_name}{What to call the added metadata}
}
\value{
dataframe with new column named after `new_col_name`
}
\description{
Annotates a dataframe containined well identifiers with metadata in the
form of a platemap matrix, matching the existing well-labels to the well
position in the platemap
}

