% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_plate.R
\name{view_plate}
\alias{view_plate}
\title{Displays the data in the form of a microtiter plate.}
\usage{
view_plate(data, well_ids_column, columns_to_display, plate_size = 96)
}
\arguments{
\item{data}{A data frame containing the data}

\item{well_ids_column}{The name of the column in \code{data} containing the 
well IDs.}

\item{columns_to_display}{A vector of the names of one or more columns you'd
like to display.}

\item{plate_size}{The number of wells in the plate. Must be 12, 24, 48, 96 or
384. Default 96.}
}
\value{
A depiction of the data in \code{columns_to_display} as 
though laid out on a microtiter plate with \code{plate_size} wells.
}
\description{
Displays the data in the form of a microtiter plate.
}
\examples{
# Generate some tidy data
data <- data.frame(Wells = paste0(LETTERS[1:3], 0, rep(1:4, each = 3)), 
Species = rep(c("Alien", "Human", "Cat"), 4), 
OxygenProduction = round(rnorm(12), 3))
head(data)

# See which wells had cells from which species and the amount of oxygen 
# produced for each well
view_plate(data, "Wells", c("Species", "OxygenProduction"), 12)
}

