% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advanced_search.R
\name{advanced_search}
\alias{advanced_search}
\title{Advanced CRAN package search}
\usage{
advanced_search(
  ...,
  json = NULL,
  format = c("short", "long"),
  from = 1,
  size = 10
)
}
\arguments{
\item{...}{Search terms. For named terms, the name specifies the field
to search for. For unnamed ones, the term is taken as is. The
individual terms are combined with the \code{AND} operator.}

\item{json}{A character string that contains the query to
send to Elastic. If this is not \code{NULL}, then you cannot specify
any search terms in \code{...}.}

\item{format}{Default formatting of the results. \emph{short} only
outputs the name and title of the packages, \emph{long} also
prints the author, last version, full description and URLs.
Note that this only affects the default printing, and you can
still inspect the full results, even if you specify \emph{short}
here.}

\item{from}{Where to start listing the results, for pagination.}

\item{size}{The number of results to list.}
}
\value{
Search hits.
}
\description{
See the Elastic documentation for the syntax and features:
https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-query-string-query.html
}
\examples{
\dontshow{if (pingr::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# All orphaned packages
advanced_search(Maintainer = "ORPHANED")

# Packages with both Hester and Wickham as authors
advanced_search(Author = "Hester", Author = "Wickham")
advanced_search("Author: Hester AND Author: Wickham")

# Packages with Hester but not Wickham as author
advanced_search(Author = "Hester AND NOT Wickham")

# Packages with Hester as an Author, and Wickham in any field
advanced_search(Author = "Hester", "Wickham")

# Packages with Hester as an Author and Wickham nowhere in the metadata
advanced_search(Author = "Hester", "NOT Wickham")

# Packages for permutation tests and permissive licenses
advanced_search("permutation test AND NOT License: GPL OR GNU")

# Packages that have a certain field
advanced_search("_exists_" = "URL")

# Packages that do not have a certain field:
advanced_search("NOT _exists_: URL")

# The same but as JSON query
query <- '{
"query": {
  "bool": {
    "must_not": {
      "exists": {
        "field": "URL"
      }
    }
  }
}
}'
advanced_search(json = query)

# Regular expressions
advanced_search(Author = "/Joh?nathan/")

# Fuzzy search
advanced_search(Author = "Johnathan~1")
\dontshow{\}) # examplesIf}
}
