% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgdepends.R
\docType{package}
\name{pkgdepends-package}
\alias{pkgdepends}
\alias{pkgdepends-package}
\title{pkgdepends: Package Dependency Resolution and Downloads}
\description{
pkgdepends is a toolkit for package dependencies, downloads and
installations, to be used in other packages. If you are looking for a
package manager, see \href{https://github.com/r-lib/pak}{pak}.
}
\section{Features}{
\itemize{
\item Look up package dependencies recursively.
\item Visualize package dependencies.
\item Download packages and their dependencies.
\item Install downloaded packages.
\item Includes a dependency solver to find a consistent set of
dependencies.
\item Supports CRAN and Bioconductor packages automatically.
\item Supports packages on GitHub.
\item Supports local package file and trees.
\item Supports the \code{Remotes} entry in the \code{DESCRIPTION} file.
\item Caches metadata and downloaded packages via
\href{https://github.com/r-lib/pkgcache}{pkgcache}
\item Performs all downloads and HTTP queries concurrently.
\item Builds and installs packages in parallel.
}
}

\section{Install}{
Once on CRAN, install the package with:\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("pkgdepends")
}\if{html}{\out{</div>}}
}

\section{Usage}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(pkgdepends)
}\if{html}{\out{</div>}}
\subsection{Package references}{

A package reference (ref) specifies a location from which an R package
can be obtained from. Examples:\preformatted{devtools
cran::devtools
bioc::Biobase
r-lib/pkgdepends
https://github.com/r-lib/pkgdepends
local::~/works/shiny
}

See \link[=pkg_refs]{“Package references”} for details.
}

\subsection{Package dependencies}{

Dependencies of the development version of the cli package:\if{html}{\out{<div class="sourceCode r">}}\preformatted{pd <- new_pkg_deps("r-lib/pkgcache")
pd$solve()
pd$draw()
}\if{html}{\out{</div>}}\preformatted{#> r-lib/pkgcache 1.2.2.9000 [new][bld][cmp]
#> +-assertthat 0.2.1 [new]
#> +-callr 3.7.0 [new]
#> | +-processx 3.5.2 [new]
#> | | +-ps 1.6.0 [new]
#> | | \-R6 2.5.1 [new]
#> | \-R6
#> +-cli 3.1.0 [new]
#> | \-glue 1.5.0 [new]
#> +-curl 4.3.2 [new]
#> +-digest 0.6.28 [new]
#> +-filelock 1.0.2 [new]
#> +-glue
#> +-jsonlite 1.7.2 [new]
#> +-prettyunits 1.1.1 [new]
#> +-R6
#> +-processx
#> +-rappdirs 0.3.3 [new]
#> +-rlang 0.4.12 [new]
#> +-tibble 3.1.6 [new]
#> | +-ellipsis 0.3.2 [new]
#> | | \-rlang
#> | +-fansi 0.5.0 [new]
#> | +-lifecycle 1.0.1 [new]
#> | | +-glue
#> | | \-rlang
#> | +-magrittr 2.0.1 [new]
#> | +-pillar 1.6.4 [new]
#> | | +-cli
#> | | +-crayon 1.4.2 [new]
#> | | +-ellipsis
#> | | +-fansi
#> | | +-lifecycle
#> | | +-rlang
#> | | +-utf8 1.2.2 [new]
#> | | \-vctrs 0.3.8 [new]
#> | |   +-ellipsis
#> | |   +-glue
#> | |   \-rlang
#> | +-pkgconfig 2.0.3 [new]
#> | +-rlang
#> | \-vctrs
#> \-uuid 1.0-3 [new]
#> 
#> Key:  [new] new | [bld] build | [cmp] compile
}

See the \code{\link{pkg_deps}} class for details.
}

\subsection{Package downloads}{

Downloading all dependencies of a package:\if{html}{\out{<div class="sourceCode r">}}\preformatted{pdl <- new_pkg_download_proposal("r-lib/cli")
pdl$resolve()
pdl$download()
}\if{html}{\out{</div>}}

See the \code{\link{pkg_download_proposal}} class for
details.
}

\subsection{Package installation}{

Installing or updating a set of package:\if{html}{\out{<div class="sourceCode r">}}\preformatted{lib <- tempfile()
pdi <- new_pkg_installation_proposal(
  "r-lib/cli",
  config = list(library = lib)
)
pdi$solve()
pdi$download()
pdi$install()
}\if{html}{\out{</div>}}
}

\subsection{Dependency resolution}{

\code{\link{pkg_deps}},
\code{\link{pkg_download_proposal}} and
\code{\link{pkg_installation_proposal}} all resolve
their dependencies recursively, to obtain information about all packages
needed for the specified \link[=pkg_refs]{package references}. See
\link[=pkg_resolution]{“Dependency resolution”} for details.
}

\subsection{The dependency solver}{

The dependency solver takes the resolution information, and works out
the exact versions of each package that must be installed, such that
version and other requirements are satisfied. See \link[=pkg_solution]{“The dependency solver”} for details.
}

\subsection{Installation plans}{

\code{\link{pkg_installation_proposal}} can create
installation plans, and then also install them. It is also possible to
import installation plans that were created by other tools. See
\link[=install_plans]{“Installation plans”} for details.
}

\subsection{Configuration}{

The details of \code{\link{pkg_deps}},
\code{\link{pkg_download_proposal}} and
\code{\link{pkg_installation_proposal}} can be tuned
with a list of configuration options. See
\link[=pkgdepends-config]{“Configuration”} for details.
}
}

\section{Related}{
\itemize{
\item \href{https://github.com/r-lib/pak}{pak} – R package manager
\item \href{https://github.com/r-lib/pkgcache}{pkgcache} – Metadata and package
cache
\item \href{https://github.com/r-lib/devtools}{devtools} – Tools for R package
developers
}
\subsection{Code of Conduct}{

Please note that the pkgdepends project is released with a \href{https://r-lib.github.io/pkgdepends/dev/CODE_OF_CONDUCT.html}{Contributor Code of Conduct}.
By contributing to this project, you agree to abide by its terms.
}
}

\section{License}{
MIT (c) RStudio
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-lib/pkgdepends#readme}
  \item Report bugs at \url{https://github.com/r-lib/pkgdepends/issues}
}

}
\author{
\strong{Maintainer}: Gábor Csárdi \email{csardi.gabor@gmail.com}

Other contributors:
\itemize{
  \item RStudio [copyright holder, funder]
}

}
