% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{http_stop_for_status}
\alias{http_stop_for_status}
\title{Throw R errors for HTTP errors}
\usage{
http_stop_for_status(resp)
}
\arguments{
\item{resp}{HTTP response from \code{\link[=http_get]{http_get()}}, \code{\link[=http_head]{http_head()}}, etc.}
}
\value{
The HTTP response invisibly, if it is considered successful.
Otherwise an error is thrown.
}
\description{
Status codes below 400 are considered successful, others will trigger
errors. Note that this is different from the \code{httr} package, which
considers the 3xx status code errors as well.
}
\examples{
\donttest{
afun <- async(function() {
  http_get("https://eu.httpbin.org/status/404")$
    then(http_stop_for_status)
})

tryCatch(synchronise(afun()), error = function(e) e)
}
}
