% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_to_sprinkle.R
\name{index_to_sprinkle}
\alias{index_to_sprinkle}
\title{Determine the Indices to Sprinkle}
\usage{
index_to_sprinkle(
  x,
  rows = NULL,
  cols = NULL,
  fixed = FALSE,
  part = c("body", "head", "foot", "interfoot"),
  recycle = c("none", "rows", "cols", "columns"),
  coll = NULL
)
}
\arguments{
\item{x}{An object of class \code{dust}.}

\item{rows}{Either a numeric vector of rows in the tabular object to be 
modified or an object of class \code{call}.  When a \code{call}, 
generated by \code{quote(expression)}, the expression resolves to 
a logical vector the same length as the number of rows in the table.
Sprinkles are applied to where the expression resolves to \code{TRUE}.}

\item{cols}{Either a numeric vector of columns in the tabular object to
be modified, or a character vector of column names. A mixture of 
character and numeric indices is permissible.}

\item{fixed}{\code{logical(1)} indicating if the values in \code{rows} and 
\code{cols} should be read as fixed coordinate pairs.  See Details.}

\item{part}{\code{character} string.  Specifies if the sprinkles are 
being applied to the head, body, foot, or interfoot of the table. Partial
matching is supported.}

\item{recycle}{\code{character} string. Indicates how recycling is to be
performed.  Partial matching is supported. See Details.}

\item{coll}{An optional \code{AssertCollection} object. When \code{NULL},
an \code{AssertCollection} object will be created and reported within
the call to this function.  When not \code{NULL}, any failed assertions
will be added to the object in reported in the function that called
\code{index_to_sprinkle}.}
}
\description{
The sprinkle methods accept the rows and columns that are
  to be modified as matrix coordinates.  The \code{dust} object stores
  the table data in a long form.  The tabular coordinates are translated
  into row indices using this function.
}
\details{
When \code{fixed = FALSE}, sprinkles are applied at the 
  intersection of \code{rows} and \code{cols}, meaning that the arguments 
  do not have to share the same length.  When \code{fixed = TRUE}, they must
  share the same length.
  
  The value of \code{recycle} determines how sprinkles are 
  managed when the sprinkle input doesn't match the length of the region
  to be sprinkled.  By default, recycling is turned off.  Recycling 
  may be performed across rows first (left to right, top to bottom), 
  or down columns first (top to bottom, left to right).  \code{"cols"} 
  and \code{"columns"} have the same effect. The two choices to specify 
  are motivated by the fact that I sometimes get confused about which
  it should be. :)
}
\section{Functional Requirements}{

\enumerate{
 \item Return the indices of the intersection of \code{rows} and \code{cols}
 \item If \code{rows = NULL}, assume all rows.
 \item If \code{rows} is an expression where no values resolve to 
   \code{TRUE}, return \code{x} unchanged.
 \item If any value in \code{rows} is not a valid row in the table,
   cast an error.
 \item If \code{cols = NULL}, assume all columns.
 \item If any value in \code{cols} does not identify a column in the table,
   cast an error.
 \item If \code{fixed = TRUE}, \code{length(rows)} (or \code{sum(rows),
   if an expression}) and \code{cols} must have the same length.
 \item Cast an error if \code{fixed} is not a \code{logical(1)}
 \item Cast an error if \code{part} is not one of \code{"body"}, 
   \code{"head"}, \code{"foot"}, or \code{"interfoot"}.
}
}

\seealso{
\code{sprinkle}
}
\author{
Benjamin Nutter
}
