% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_font.R
\name{sprinkle_font}
\alias{sprinkle_font}
\alias{sprinkle_font.default}
\alias{sprinkle_font.dust_list}
\title{Sprinkle the Characteristics of Text in a Cell}
\usage{
sprinkle_font(x, rows = NULL, cols = NULL, bold = NULL, italic = NULL,
  font_size = NULL, font_size_units = NULL, font_color = NULL,
  font_family = NULL, ..., part = c("body", "head", "foot", "interfoot",
  "table"), fixed = FALSE, recycle = "none")

\method{sprinkle_font}{default}(x, rows = NULL, cols = NULL, bold = NULL,
  italic = NULL, font_size = NULL, font_size_units = NULL,
  font_color = NULL, font_family = NULL, ..., part = c("body", "head",
  "foot", "interfoot", "table"), fixed = FALSE, recycle = "none")

\method{sprinkle_font}{dust_list}(x, rows = NULL, cols = NULL,
  bold = NULL, italic = NULL, font_size = NULL, font_size_units = NULL,
  font_color = NULL, font_family = NULL, ..., part = c("body", "head",
  "foot", "interfoot", "table"), fixed = FALSE, recycle = "none")
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{rows}{Either a numeric vector of rows in the tabular object to be 
modified or an object of class \code{call}.  When a \code{call}, 
generated by \code{quote(expression)}, the expression resolves to 
a logical vector the same length as the number of rows in the table.
Sprinkles are applied to where the expression resolves to \code{TRUE}.}

\item{cols}{Either a numeric vector of columns in the tabular object to
be modified, or a character vector of column names. A mixture of 
character and numeric indices is permissible.}

\item{bold}{\code{logical(1)} indicating if the text in the selected cells
should be made bold.}

\item{italic}{\code{logical(1)} indicating if the text in the selected 
cells should be made italic.}

\item{font_size}{\code{numeric(1)} giving the font size.}

\item{font_size_units}{\code{character(1)} giving the units of the font 
size.  May be any of \code{c("px", "pt", "\%", "em")}. LaTeX output only
recognizes \code{"pt"} and \code{"em"}. For LaTeX output, \code{"px"} is
quietly changed to \code{"pt"} when printing.}

\item{font_color}{\code{character(1)} giving a valid color name for the 
text.}

\item{font_family}{\code{character(1)} giving the font name for the text. 
This is only recognized in HTML output.}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}

\item{part}{A character string denoting which part of the table to modify.}

\item{fixed}{\code{logical(1)} indicating if the values in \code{rows} 
and \code{cols} should be read as fixed coordinate pairs.  By default, 
sprinkles are applied at the intersection of \code{rows} and \code{cols}, 
meaning that the arguments do not have to share the same length.  
When \code{fixed = TRUE}, they must share the same length.}

\item{recycle}{A \code{character} one that determines how sprinkles are 
managed when the sprinkle input doesn't match the length of the region
to be sprinkled.  By default, recycling is turned off.  Recycling 
may be performed across rows first (left to right, top to bottom), 
or down columns first (top to bottom, left to right).}
}
\description{
Text can be made to stand out (or fade away) by using font 
  features such as bold and italic text, color, size, or different fonts.
}
\details{
The \code{bold} and \code{italic} features are recognized by all 
  formats.  
  
  Font size features are recognized by HTML and LaTeX. LaTeX only recognizes 
  the font size unit options of \code{"pt"} and \code{"em"}, but will quietly
  change \code{"px"} to \code{"pt"} when printing.
  
  Font color features are recognized by HTML and LaTeX.
  
  Font family is only recognized by HTML.
}
\section{Functional Requirements}{

\enumerate{
  \item Correctly change the \code{bold} column of the table part for 
    the selected cells.
  \item Correctly change the \code{italic} column of the table part for 
    the selected cells.
  \item Correctly change the \code{font_size} column of the table part for 
    the selected cells.
  \item Correctly change the \code{font_size_units} column of the table part for 
    the selected cells.
  \item Correctly chagne the \code{font_color} column of the table part 
    for the selected cells.
  \item Correctly change the \code{font_family} column of the table part for 
    the selected cells.
  \item Cast an error if \code{x} is not a dust object.
  \item Cast an error if \code{bold} is not \code{logical(1)}
  \item Cast an error if \code{italic} is not \code{logical(1)}
  \item Cast an error if \code{font_size} is not \code{numeric(1)}
  \item Cast an error if \code{font_size_units} is not \code{character(1)}
  \item Cast an error if \code{font_size_units} is not one of 
    px, pt, em, or %
  \item Cast an error if \code{font_color} is not \code{character(1)}
  \item Cast an error if \code{font_family} is not \code{character(1)}
  \item Cast an error if \code{part} is not a subset of \code{c("body", 
    "head", "foot", "interfoot")}
 \item Cast an error if \code{recycle = "none"} and \code{bold}
   does not have length 1.
 \item Cast an error if \code{recycle = "none"} and \code{italic}
   does not have length 1.
 \item Cast an error if \code{recycle = "none"} and \code{font_size}
   does not have length 1.
 \item Cast an error if \code{recycle = "none"} and \code{font_size_units}
   does not have length 1.
 \item Cast an error if \code{recycle = "none"} and \code{font_color}
   does not have length 1.
 \item Cast an error if \code{recycle = "none"} and \code{font_family}
   does not have length 1.
}

The functional behavior of the \code{fixed} and \code{recycle} arguments 
is not tested for this function. It is tested and validated in the
tests for \code{\link{index_to_sprinkle}}.
}

\seealso{
\code{\link{sprinkle}}
}
\author{
Benjamin Nutter
}
