% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixel_rule.R
\name{pixel_rule}
\alias{pixel_rule}
\alias{is.rule}
\alias{summary.pixel_rule}
\title{Creates a rule object}
\usage{
pixel_rule(rule_name, x_axis, y_axis, line_points, comp_op)

is.rule(x)

\method{summary}{pixel_rule}(object, ...)
}
\arguments{
\item{rule_name}{a character string containing the name of the rule.}

\item{x_axis}{a character string selecting the colour variable used as x
axis, one of \code{"r"}, \code{"g"} or \code{"b"}.}

\item{y_axis}{a character string selecting the colour variable used as y
axis, one of \code{"r"}, \code{"g"} or \code{"b"}.}

\item{line_points}{either an object of  of class \code{"rule_points"} created
with function \code{place_rule()}, or a list containing the coordinates of
two points defining the line. The coordinates are two-element numeric
vectors.}

\item{comp_op}{a character string containing one of the comparison operators
\code{">", ">=", "<", "<="}.}

\item{x}{the R object being tested}

\item{object}{an object of class \code{"pixel_category"}.}

\item{\dots}{additional parameters to pass to the function.}
}
\value{
An object of class \code{"pixel_rule"} containing these elements:
  \itemize{
  \item \code{rule_name}: a character string containing the rule name.
  \item \code{rule_text}: a character string containing the mathematical
  expression of the rule.
  \item \code{comp_op}: a character string containing the comparison operator
  used in the rule.
  \item \code{a}: a numerical vector containing the parameter \code{a}
  (slope) of the line.
  \item \code{c}: a numerical vector containing the parameter \code{c}
  (intercept) of the line.
  \item \code{x_axis}: a character string containing the colour variable
  selected as \code{x} axis (one of "r", "g" or "b").
  \item \code{y_axis}: a character string containing the colour variable
  selected as \code{y} axis.
  \item \code{first_point}: a numerical vector containing the coordinates of
  the first point used to estimate the line equation.
  \item \code{second_point}: a numerical vector containing the coordinates of
  the second point. }
}
\description{
Creates an object of class \code{pixel_rule} from a line in \code{rgb} space,
defined by the user, and a relational operator.
}
\details{
This function estimates the slope (\code{a}) and intercept
  (\code{c}) of the line \code{y = ax + c} from the coordinates of two points
  on the line. \code{x} and \code{y} are two colour variables selected by the
  user (\code{r}, \code{g}, or \code{b}). The line divides the plane in two
  subsets and the comparison operator selects the subset that contains the
  points (pixels) of interest.

  When the line is defined by a list containing a couple of points, it is
  first converted into an object of class \code{"pixel_rule_points"} (see
  \code{\link{place_rule}}, and the examples below).

  The lines are mathematical objects that extend without bound, i.e. all
  along the x axis. The pair of points do not set the line limits, they only
  allow the estimation of the line parameters. Therefore, they are not
  constrained to be inside the triangular area occupied by the pixels, and
  the points can be selected in the most convenient way, provided that the
  line divides correctly the categories. Convenience in this context means
  that the line should seem nice in the plot, if this matters.

  Because the variables were transformed into proportions, the pixels in the
  plot are always inside the triangle defined by the points \code{(0, 0), (1,
  0), (0, 1)}. So, the sides of this triangle can be considered as implicit
  rules which do not need to be created explicitly. In this way, a single
  line creates two polygons by cutting the triangle in two. Usually, the
  implicit rules reduce the number of rules to create.
}
\examples{
# Creating the line by passing the coordinates of two points on the line:
rule01 <- pixel_rule("rule01", "g", "b",
                      list(c(0.35, 0.30), c(0.45, 0.10)),">")

# A vertical line as a rule; note that the equation will be simplified
rule02 <- pixel_rule("rule02", "g", "b",
                      list(c(0.35, 0.30), c(0.35, 0.00)), ">")
\dontrun{
# Creating the rule by passing an object of type rule_point:
rule_points01 <- place_rule("g", "b")
rule03 <- pixel_rule("rule03", "g", "b", rule_points01,">")

# Note that the creation of the intermediate object can be avoided:
rule04 <- pixel_rule("rule04", "g", "b", place_rule("g", "b"),">")
}
}
\seealso{
\code{\link{pixel_subcategory}}, \code{\link{pixel_category}},
  \code{\link{plot_rule}}, \code{\link{plot_rgb_plane}}
}
