% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotStyles.R
\docType{class}
\name{PivotStyles}
\alias{PivotStyles}
\title{A class that defines a collection of styles.}
\format{\code{\link{R6Class}} object.}
\value{
Object of \code{\link{R6Class}} with properties and methods that
  define styles/a theme for a pivot table.
}
\description{
The PivotStyles class defines all of the base styles needed to style/theme a
pivot table.  It also defines the names of the styles that are used for
styling the different parts of the pivot table.
}
\section{Fields}{

\describe{
\item{\code{parentPivot}}{Owning pivot table.}

\item{\code{themeName}}{The name of the theme.}

\item{\code{allowExternalStyles}}{Enables integration scenarios where an external
system is supplying the CSS definitions.}

\item{\code{tableStyle}}{The name of the style for the HTML table element.}

\item{\code{rootStyle}}{The name of the style for the HTML cell at the top left of
the pivot table.}

\item{\code{rowHeaderStyle}}{The name of the style for the row headers in the pivot
table.}

\item{\code{colHeaderStyle}}{The name of the style for the column headers in the
pivot table.}

\item{\code{outlineRowHeaderStyle}}{The name of the style for the outline row
headers in the pivot table.}

\item{\code{outlineColHeaderStyle}}{The name of the style for the outline column
headers in the pivot table.}

\item{\code{cellStyle}}{The name of the cell style for the non-total cells in the
body of the pivot table.}

\item{\code{outlineCellStyle}}{The name of the cell style for the non-total
outline cells in the body of the pivot table.}

\item{\code{totalStyle}}{The name of the cell style for the total cells in the pivot
table.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new set of styles, specifying the field
  values documented above.}

  \item{\code{isExistingStyle(styleName)}}{Check whether the specified style
  exists.}
  \item{\code{getStyle(styleName)}}{Get the specified style.}
  \item{\code{addStyle(styleName, declarations)}}{Add a new style to the
  collection of styles.}
  \item{\code{copyStyle(styleName, newStyleName)}}{Create a copy of a style
  with the specified name.}
  \item{\code{asCSSRule(styleName, selector)}}{Get a style definition in the
  form of a CSS rule.}
  \item{\code{asNamedCSSStyle(styleName, styleNamePrefix)}}{Get a style
  definition in the form of a named CSS style.}
  \item{\code{asList()}}{Get a list representation of the styles.}
  \item{\code{asJSON()}}{Get a JSON representation of the styles.}
  \item{\code{asString()}}{Get a text representation of the styles.}
}
}

\examples{
pt <- PivotTable$new()
# ...
pivotStyles <- PivotStyles$new(pt, themeName="compact")
pivotStyles$addStyle(styleName="MyNewStyle", list(
    font="0.75em arial",
    padding="2px",
    border="1px solid lightgray",
    "vertical-align"="middle",
    "text-align"="center",
    "font-weight"="bold",
    "background-color"="#F2F2F2"
  ))
}
