% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotOpenXlsxRenderer.R
\docType{class}
\name{PivotOpenXlsxRenderer}
\alias{PivotOpenXlsxRenderer}
\title{A class that renders a pivot table into an Excel worksheet.}
\format{\code{\link{R6Class}} object.}
\usage{
PivotOpenXlsxRenderer
}
\value{
Object of \code{\link{R6Class}} with properties and methods that
  render to Excel via the openxlsx package
}
\description{
The PivotOpenXlsxRenderer class creates a representation of a pivot table in an Excel file using the openxlsx package.
}
\section{Fields}{

\describe{
\item{\code{parentPivot}}{Owning pivot table.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new pivot table renderer, specifying the
  field value documented above.}

  \item{\code{clearIsRenderedFlags()}}{Clear the IsRendered flags that exist
  on the PivotDataGroup class.}
  \item{\code{writeToCell(wb=NULL, wsName=NULL, rowNumber=NULL,
  columnNumber=NULL, value=NULL, applyStyles=TRUE, baseStyleName=NULL,
  style=NULL, mapFromCss=TRUE)}}{Writes a value to a cell and applies styling
  as needed.}
  \item{\code{writeToWorksheet(wb=NULL, wsName=NULL, topRowNumber=NULL,
  leftMostColumnNumber=NULL, outputValuesAs="value", applyStyles=TRUE,
  mapStylesFromCSS=TRUE, exportOptions=NULL)}}{Output the pivot table into
  the specified workbook and worksheet at the specified row-column location.}
}
}

\examples{
# This class should only be created by the pivot table.
# It is not intended to be created outside of the pivot table.
}
\keyword{datasets}
