\name{animateFX}
\alias{animateFX}
\title{Animate PITCHf/x}
\usage{
  animateFX(data, color = "pitch_types", avg.by,
    point.alpha = 1/3, limitz = c(-3.5, 3.5, 0, 7),
    flag = FALSE, interval = 0.01, layer = list(),
    parent = FALSE, ...)
}
\arguments{
  \item{data}{data frame with appropriately named PITCHf/x
  variables}

  \item{color}{variable used to control coloring scheme.}

  \item{avg.by}{variable used as an index for averaging
  over PITCHf/x parameters}

  \item{point.alpha}{ggplot2 alpha parameter}

  \item{limitz}{limits for horizontal and vertical axes.}

  \item{flag}{indicate whether or not batter has decided to
  swing.}

  \item{interval}{time (in seconds) between plotting the
  pitch locations.}

  \item{layer}{list of ggplot2 layer modifications.}

  \item{parent}{is the function being called from a
  higher-level function? (experimental)}

  \item{...}{extra options passed onto geom commands}
}
\value{
  Returns a series of ggplot2 objects.
}
\description{
  Pitch trajectories animated on a two-dimensional plot.
}
\details{
  \code{animateFX} plots a series of "snapshots" that
  represent pitch trajectories from the point of release
  until all of them reach home plate. The graphic takes on
  the viewpoint of the umpire; that is, the pitches are
  getting closer to the viewer with time. This is relected
  with the increase in size of the "balls" as the animation
  progresses.
}
\examples{
data(pitches)
#generate animation and prompt browser to view the sequence of plots
\dontrun{
animation::saveHTML({ animateFX(pitches, layer = facet_grid(pitcher_name~stand)) })
animation::saveHTML({ animateFX(pitches, avg.by="pitch_types",
                         layer = facet_grid(pitcher_name~stand))
                   })
}
}

