% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_exemplary_dd_tree.R
\name{create_exemplary_dd_tree}
\alias{create_exemplary_dd_tree}
\title{Create an exemplary diversity-dependent (DD) birth-death tree.}
\usage{
create_exemplary_dd_tree(n_taxa = 6, crown_age = 10, extinction_rate = 0.1)
}
\arguments{
\item{n_taxa}{number of tree tips}

\item{crown_age}{the fixed crown age of the posterior. Set to NA
to let it be estimated}

\item{extinction_rate}{per-species extinction rate}
}
\value{
a \link[ape]{phylo}
}
\description{
Create an exemplary diversity-dependent (DD) birth-death tree,
that is, a DD tree with a strong DD effect.
The DD tree produced most likely has the desired number
of taxa, but this is not always the case.
}
\examples{
create_exemplary_dd_tree(
  n_taxa = 3,
  crown_age = 1
)
}
\seealso{
Use \link{create_exemplary_dd_tree_giappo}
for a different way to generate exemplary trees with
a strong DD effect.
}
\author{
Giovanni Laudanno, Richèl J.C. Bilderbeek
}
