% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_n_mutations.R
\name{count_n_mutations}
\alias{count_n_mutations}
\title{Count mutations}
\usage{
count_n_mutations(alignment, root_sequence, verbose = FALSE)
}
\arguments{
\item{alignment}{a DNA alignment, of class \link[ape]{DNAbin}}

\item{root_sequence}{the DNA sequence at the root of the phylogeny.
By default, this will consist out of an equal amount of each letter
Use \link{check_root_sequence} to check if a root sequence is valid.}

\item{verbose}{if TRUE, show more output}
}
\value{
the number of mutations
}
\description{
Count mutations
}
\examples{
# Check cleanup by other functions
beastier::check_empty_beaustier_folders()

# Create an AAAA alignent
alignment <- ape::as.DNAbin(
  x = list(species_1 = strsplit("aaaa", split = "")[[1]])
)
# Count the number of mutations from AAAA
# 0
count_n_mutations(alignment, "aaaa")
# 1
count_n_mutations(alignment, "acaa")
# 2
count_n_mutations(alignment, "acga")
# 3
count_n_mutations(alignment, "acgt")
# 4
count_n_mutations(alignment, "ccgt")
}
\author{
Giovanni Laudanno, Richèl J.C. Bilderbeek
}
