% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_true_alignment.R
\name{copy_true_alignment}
\alias{copy_true_alignment}
\title{Adapter function to create
a twin alignment by simply copying the
true alignment}
\usage{
copy_true_alignment(
  true_alignment,
  twin_phylogeny = "irrelevant",
  root_sequence = "irrelevant"
)
}
\arguments{
\item{true_alignment}{a DNA alignment, of class \link[ape]{DNAbin}}

\item{twin_phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{root_sequence}{the DNA sequence at the root of the phylogeny.
By default, this will consist out of an equal amount of each letter
Use \link{check_root_sequence} to check if a root sequence is valid.}
}
\value{
the true alignment
}
\description{
Adapter function to create
a twin alignment by simply copying the
true alignment
}
\examples{
# Check cleanup by other functions
beastier::check_empty_beaustier_folders()

true_alignment <- get_test_alignment()
twin_alignment <- copy_true_alignment(true_alignment)

# twin_alignment equals true_alignment
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
