% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mono_nuc_dna.R
\name{create_mono_nuc_dna}
\alias{create_mono_nuc_dna}
\title{Create a 'blocked' DNA sequence, which is a sequence
with four equal-sized nucleotide sections}
\usage{
create_mono_nuc_dna(length, nucleotide = "a")
}
\arguments{
\item{length}{number of nucleotides}

\item{nucleotide}{number of nucleotides}
}
\value{
a string
}
\description{
Create a 'blocked' DNA sequence, which is a sequence
with four equal-sized nucleotide sections
}
\examples{
# Creates 'aaa'
create_mono_nuc_dna(length = 3)

# Creates 'ccccc'
create_mono_nuc_dna(nucleotide = "c", length = 5)
}
\seealso{
Use \link{create_blocked_dna} to create
  a DNA sequence of four equally-sized mono-noculeotide block
}
\author{
Richèl J.C. Bilderbeek
}
