% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_test_cand_experiment.R
\name{create_test_cand_experiment}
\alias{create_test_cand_experiment}
\title{Create a valid testing \link{pirouette} candidate experiment.}
\usage{
create_test_cand_experiment(
  inference_conditions = pirouette::create_inference_conditions(model_type = "candidate",
    run_if = "best_candidate", do_measure_evidence = TRUE),
  inference_model = beautier::create_test_inference_model(),
  beast2_options = beastier::create_beast2_options(),
  est_evidence_mcmc = beautier::create_test_ns_mcmc(),
  beast2_bin_path = beastier::get_default_beast2_bin_path(),
  errors_filename = get_temp_errors_filename()
)
}
\arguments{
\item{inference_conditions}{conditions under which the inference model
is used in the inference}

\item{inference_model}{an inference model, which is a combination
of site model, clock model, tree prior and BEAST2 input and
input filenames.}

\item{beast2_options}{BEAST2 options,
as can be created by \link[beastier]{create_beast2_options}}

\item{est_evidence_mcmc}{MCMC used in the estimation of
the evidence (aka marginal likelihood).
The MCMC must be a Nested Sampling MCMC,
as can be created by \link[beautier]{create_ns_mcmc}.}

\item{beast2_bin_path}{path to BEAST2 binary file. The use of the
binary BEAST2 file is required for estimation of the evidence (aka
marginal likelihood). The default BEAST2 binary path can be
obtained using \link[beastier]{get_default_beast2_bin_path}}

\item{errors_filename}{baseline name for errors filenames,
as created by \link{get_temp_errors_filename}}
}
\value{
a \link{pirouette} experiment.
}
\description{
Create a valid testing \link{pirouette} candidate experiment.
}
\examples{
if (beautier::is_on_ci() && rappdirs::app_dir()$os != "win") {
  experiment <- create_test_cand_experiment()
  check_experiment(experiment)
}
}
\author{
Richèl J.C. Bilderbeek
}
