% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin-store-fetch.R
\name{pin_fetch}
\alias{pin_fetch}
\alias{pin_store}
\title{Fetch/store a pin}
\usage{
pin_fetch(board, name, version = NULL, ...)

pin_store(board, name, paths, metadata, versioned = NULL, x = NULL, ...)
}
\arguments{
\item{board}{A pin board, created by \code{\link[=board_folder]{board_folder()}}, \code{\link[=board_connect]{board_connect()}},
\code{\link[=board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[=pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}

\item{...}{Additional arguments passed on to methods for a specific board.}

\item{paths}{A character vector of file paths to upload to \code{board}.}

\item{metadata}{A list containing additional metadata to store with the pin.
When retrieving the pin, this will be stored in the \code{user} key, to
avoid potential clashes with the metadata that pins itself uses.}

\item{versioned}{Should the pin be versioned? The default, \code{NULL}, will
use the default for \code{board}}

\item{x}{An object (typically a data frame) to pin.}
}
\value{
\code{pin_fetch()} is called primarily for its side-effect of downloading
remote pins into the local cache. It returns the same data as \link{pin_meta}.
\code{pin_store()} is called for its side-effect of uploading a local file
to a remote board. It invisibly returns the fully qualified pin name.
}
\description{
These are low-level functions that power \code{\link[=pin_read]{pin_read()}}, \code{\link[=pin_write]{pin_write()}},
\code{\link[=pin_upload]{pin_upload()}}, and \code{\link[=pin_download]{pin_download()}}. They are needed primarily for folks
developing new board types, and should not generally be called directly.
}
\examples{
board <- board_temp()

board \%>\% pin_upload(system.file("CITATION"))
path <- board \%>\% pin_download("CITATION")
path
readLines(path)[1:5]
}
\keyword{internal}
