% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy_github.R
\name{legacy_github}
\alias{legacy_github}
\alias{board_register_github}
\title{GitHub board (legacy API)}
\usage{
legacy_github(
  repo,
  branch = NULL,
  token = NULL,
  path = "",
  host = "https://api.github.com",
  name = "github",
  cache = NULL,
  ...
)

board_register_github(
  name = "github",
  repo = NULL,
  branch = NULL,
  token = NULL,
  path = "",
  host = "https://api.github.com",
  cache = NULL,
  ...
)
}
\arguments{
\item{repo}{The GitHub repository formatted as 'owner/repo'.}

\item{branch}{The branch to use to commit pins. Default, \code{NULL}, will
use \code{main} or \code{master} if present.}

\item{token}{GitHub personal access token.
Uses \href{https://gitcreds.r-lib.org}{gitcreds} if not set.}

\item{path}{The subdirectory in the repo where the pins will be stored.}

\item{host}{The URL of the GitHub API. You'll need to customise
this to use GitHub enterprise, e.g. \code{"https://yourhostname/api/v3"}.}

\item{name}{An optional name used identify the board. This is no longer
generally needed since you should be passing around an explicit
board object.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}

\item{...}{Additional parameters required to initialize a particular board.}
}
\description{
To use a GitHub board, you'll need to set up authentication, following
the instructions at \url{https://happygitwithr.com/https-pat.html#https-pat}.
}
\section{Large Files}{
A GitHub repo only supports files under 25MB in size (100MB in theory but
there is additional overhead when using the GitHub API). To store large
files, GitHub
\href{https://help.github.com/en/articles/distributing-large-binaries}{recommends}
storing them using GitHub Releases which support up to 2GB files, which
is what pins uses. You don't need to do anything extra as this will happen
behind the scenes, but don't be surprised if pins creates releases in your
repo.
}

\examples{
\dontrun{
# the following example requires a GitHub API key
board <- legacy_github("owner/repo")
}
}
