% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin.R
\name{pin}
\alias{pin}
\title{Pin Resource}
\usage{
pin(x, name = NULL, description = NULL, board = NULL, ...)
}
\arguments{
\item{x}{An object, local file or remote URL to pin.}

\item{name}{The name for the dataset or object.}

\item{description}{Optional description for this pin.}

\item{board}{The board where this pin will be placed.}

\item{...}{Additional parameters.}
}
\description{
Pins the given resource locally or to the given board.
}
\details{
\code{pin()} allows you to cache remote resources and intermediate results with ease. When
caching remote resources, usually URLs, it will check for HTTP caching headers to avoid
re-downloading when the remote result has not changed.

This makes it ideal to support reproducible research by requiring manual instruction to
download resources before running your R script.

In addition, \code{pin()} still works when working offline or when the remote resource
becomes unavailable; when this happens, a warning will be triggered but your code will
continue to work.
}
\examples{
library(pins)

# define local board
board_register_local(cache = tempfile())

# cache the mtcars dataset
pin(mtcars)

# cache computation oveer mtcars
mtcars[mtcars$mpg > 30,] \%>\%
  pin(name = "mtefficient")

# retrieve cached pin
pin_get("mtefficient")

# url to remote resource
resource <- file.path("https://raw.githubusercontent.com/facebook/prophet",
                      "master/examples/example_retail_sales.csv")

# cache remote resource
pin(resource, name = "example_retail_sales")

# load cached csv
pin_get("example_retail_sales") \%>\% read.csv()

# cache and read csv
read.csv(pin(resource))

}
