% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_cluster.R
\name{ighvClust}
\alias{ighvClust}
\title{Allele similarity clustering}
\usage{
ighvClust(
  germline_distance,
  family_threshold = 75,
  allele_cluster_threshold = 95,
  cluster_method = "complete"
)
}
\arguments{
\item{germline_distance}{A germline set distance matrix created by \code{ighvDistance}.}

\item{family_threshold}{The similarity threshold for the family level. Default is 75.}

\item{allele_cluster_threshold}{The similarity threshold for the allele cluster level. Default is 95.}

\item{cluster_method}{The hierarchical clustering method to use. Default is "complete".}
}
\value{
A names list that includes the \code{data.frame} of the alleles clusters, the thresholds parameters and the
hierarchical clustering of the germline set.
}
\description{
Cluster the distance matrix from \code{ighvDistance} to create the allele clusters based on two thresholds:
75\% similarity which represents the family clustering and 95\% similarity between alleles which represents the allele clusters
}
