% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_piece.R
\name{geom_piece}
\alias{geom_piece}
\alias{aes_piece}
\title{Draw board game pieces with ggplot2}
\usage{
geom_piece(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  envir = getOption("piecepackr.envir", piecepackr::game_systems()),
  op_scale = getOption("piecepackr.op_scale", 0),
  op_angle = getOption("piecepackr.op_angle", 45),
  inherit.aes = TRUE
)

aes_piece(df)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Aesthetics, used to set an aesthetic to a fixed value.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{op_scale}{How much to scale the depth of the piece in the oblique projection
(viewed from the top of the board).
\code{0} (the default) leads to an \dQuote{orthographic} projection,
\code{0.5} is the most common scale used in the \dQuote{cabinet} projection,
and \code{1.0} is the scale used in the \dQuote{cavalier} projection.}

\item{op_angle}{What is the angle of the oblique projection?  Has no effect if \code{op_scale} is \code{0}.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{df}{A data frame of game piece information with (at least) the
named columns \dQuote{piece_side}, \dQuote{x}, and \dQuote{y}.}
}
\description{
\code{geom_piece()} creates a \code{ggplot2} geom.
\code{aes_piece()} takes a data frame and generates
an appropriate \code{ggplot2::aes()} mapping.
}
\details{
\code{geom_piece()} requires a fixed scale coordinate system with an aspect
ratio of 1 as provided by \code{ggplot2::coord_fixed()}.
\code{geom_piece()} also requires that \code{cfg} is a character vector (and not a \code{pp_cfg()} object).
In particular if using \code{op_transform()} one should set its argument \code{cfg_class = "character"}
if intending for use with \code{geom_piece()}.
}
\section{Aesthetics}{

\code{geom_piece()} understands the following aesthetics (required aesthetics are in bold).
See \code{\link[=pieceGrob]{pieceGrob()}} for more details.
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{z}
\item \code{piece_side}
\item \code{rank}
\item \code{suit}
\item \code{cfg}
\item \code{width}
\item \code{height}
\item \code{depth}
\item \code{angle}
\item \code{scale}
\item \code{type}
}
}

\examples{
if (require("ggplot2") && require("tibble")) {

  envir <- game_systems("sans")
  df_board <- tibble(piece_side = "board_face", suit = 3, rank = 8,
                 x = 4.5, y = 4.5)
  df_w <- tibble(piece_side = "bit_face", suit = 6, rank = 1,
                 x = rep(1:8, 2), y = rep(1:2, each=8))
  df_b <- tibble(piece_side = "bit_face", suit = 1, rank = 1,
                 x = rep(1:8, 2), y = rep(7:8, each=8))
  df <- rbind(df_board, df_w, df_b)
  # `cfg` must be a character vector for `geom_piece()`
  ggplot(df, aes_piece(df)) +
      geom_piece(cfg = "checkers1", envir = envir) +
      coord_fixed() + theme_void()
}

}
\seealso{
\code{geom_piece()} is a wrapper around \code{\link[=pieceGrob]{pieceGrob()}}.
}
