% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmi.R
\name{ideal_weight}
\alias{ideal_weight}
\alias{ideal_weight_adult}
\alias{ideal_weight_child}
\alias{ideal_weight_Devine}
\alias{ideal_weight_Robinson}
\alias{ideal_weight_Miller}
\alias{ideal_weight_Broca}
\alias{ideal_weight_Lemmens}
\title{ideal weight for adults}
\usage{
ideal_weight(height_m, ..., age_y = NULL, male = NULL)

ideal_weight_adult(height_m, male, ...)

ideal_weight_child(height_m, age_y = NULL, ...)

ideal_weight_Devine(height_m, male, ...)

ideal_weight_Robinson(height_m, male, ...)

ideal_weight_Miller(height_m, male, ...)

ideal_weight_Broca(height_m, male, ...)

ideal_weight_Lemmens(height_m, ...)
}
\arguments{
\item{height_m}{single numeric, height in meters}

\item{...}{arguments passed to downstream functions, e.g. \code{warn = TRUE}}

\item{age_y}{numeric vector, age(s) in years. Extremely exact age is not
required, so for age in days or months, simplest just to divide. This is
not used in the calculation itself, so may be missing.}

\item{male}{logical value(s) whether patient is male. TRUE or FALSE.}
}
\description{
\code{ideal_weight_adult} gives the ideal weight using default
  adult algorithm, Devine. If an age is specified and less than 18 years, the
  Traub function will be used.

Devine method is the default and most widely used. Normally
  stated in inches. Male: 50kg + 2.3kg * inches over 5ft. Female: 45.5kg +
  2.3kg * inches over 5ft. (from 1974 genatamicin paper - see Lemmens for
  ref.)

Robinson's method for ideal weight: different linear
  relationship. (Robinson JD, Lupkiewicz SM, Palenik L et al. Determination
  of ideal body weight for drug dosage calculations. Am J Hosp Pharm 1983;
  40: 1016-9.)

Miller's method for ideal weight: different linear relationship.
  (Miller DR, Carlson JD, Loyd BJ et al. Determining ideal body weight.
  (Letter). Am J Hosp Pharm 1983; 40: 1622.)

Calculate ideal weight based on Broca (1871) Height in cm -100
  for women, -105 for men Broca PP. Memoires d'anthropologie. Paris 1871 /
  1877.

Lemmens method assumes BMI 22 as ideal (Obesity Surgery 2005)
}
\section{Functions}{
\itemize{
\item \code{ideal_weight_adult}: Ideal weight of an adult

\item \code{ideal_weight_child}: Ideal weight of a child, age >= 1 and age < 18 years
}}

\examples{
ideal_weight_adult(1.7, male = TRUE)
ideal_weight_adult(1.7, male = FALSE)
ideal_weight_adult(6 * 12 * 2.54 / 100, male = TRUE) # 6ft
suppressWarnings(ideal_weight_adult(5, male = FALSE))
}
\concept{BMI}
\concept{body mass index}
\concept{ideal weight}
