% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dist2WR.R
\name{Dist2WR}
\alias{Dist2WR}
\title{Compute gene x species matrix from the result of Distatis}
\usage{
Dist2WR(Distatis)
}
\arguments{
\item{Distatis}{output of the fonction \code{DistatisFast}.}
}
\value{
A matrix (gene=rows x species=col). Each cell represents a 
gene/species pair, whose value represents the distance between (i) the position of this species
in this gene tree and (ii) the average position of this species in all other gene trees.
}
\description{
\code{Dist2WR} computes the 2WR matrix from the results obtaind with \code{DistatisFast}
(the fast version of distatis). For internal use mostly.
}
\examples{
data(carnivora)
matrices<-phylter(carnivora, InitialOnly=TRUE, parallel=FALSE)$matrices
ds<-DistatisFast(matrices, parallel = FALSE)
WR<-Dist2WR(ds) #returns the gene x species matrix

}
