\name{phy2dat}
\alias{phy2dat}
\title{
Convert phylip file to dataframe
}
\description{
Convert phylip file to dataframe
}
\usage{
phy2dat(x)
}
\arguments{
  \item{x}{
Vecter of phylip format generated by Clustal software.
}
}
\details{
Convert phylip file to dataframe. The phylip format vector can be read from local files via \code{read.phy}, or even \code{readLines}.
}
\value{
data frame with the first column the names of the input sequences, and the sequences in the second column.
}
\references{
Kress W., Erickson D., Jones F., Swenson N., Perez R., Sanjur O., Bermingham E., Plant DNA barcodes and community phylogeny of a tropical forest dynamics plot in Panama. Proceedings of the National Academy of Sciences of the United States of America. 2009 18621-18626
}
\author{
Jinlong Zhang \email{jinlongzhang01@gmail.com}
}
\note{
None
}

\seealso{
See Also \code{\link{read.phy}}
}
\examples{

##phy2dat examle ########
dir <- system.file("extdata", package = "phylotools")
setwd(dir)
test <- read.phy("rbcla.phy")
phy2dat(test)

}

\keyword{ phylip }
\keyword{ dataframe }
