% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-get.R
\name{get_sq_slot}
\alias{get_sq_slot}
\title{Get slot data for each sequence}
\usage{
get_sq_slot(phylota, cid = NULL, sid = NULL, slt_nm = list_seqrec_slots())
}
\arguments{
\item{phylota}{Phylota object}

\item{cid}{Cluster ID}

\item{sid}{Sequence ID(s)}

\item{slt_nm}{Slot name}
}
\value{
vector
}
\description{
Get slot data for either or sequences in a cluster of
a vector of sequence IDs. Use list_seqrec_slots() for a list of
available slots.
}
\examples{
data('aotus')
random_sid <- sample(aotus@sids, 1)
(get_sq_slot(phylota = aotus, sid = random_sid, slt_nm = 'dfln'))
# see list_seqrec_slots() for available slots
(list_seqrec_slots())
}
\seealso{
Other tools-public: \code{\link{calc_mad}},
  \code{\link{calc_wrdfrq}}, \code{\link{drop_by_rank}},
  \code{\link{drop_clstrs}}, \code{\link{drop_sqs}},
  \code{\link{get_clstr_slot}}, \code{\link{get_nsqs}},
  \code{\link{get_ntaxa}}, \code{\link{get_stage_times}},
  \code{\link{get_tx_slot}}, \code{\link{get_txids}},
  \code{\link{is_txid_in_clstr}},
  \code{\link{is_txid_in_sq}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_pa}},
  \code{\link{plot_phylota_treemap}},
  \code{\link{read_phylota}}, \code{\link{write_sqs}}
}
