% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylosamp_funcs.R
\name{prob_trans_mtsl}
\alias{prob_trans_mtsl}
\title{Probability of transmission assuming multiple-transmission and single-linkage}
\usage{
prob_trans_mtsl(chi, eta, rho, M, R)
}
\arguments{
\item{chi}{scalar or vector giving the specificity of the linkage criteria}

\item{eta}{scalar or vector giving the sensitivity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen}
}
\value{
scalar or vector giving the probability of transmission between two cases given linkage by phylogeneitic criteria
}
\description{
This function calculates the probabilitiy that two cases are linked by direct transmission
given that they have been linked by phylogenetic criteria. The multiple-transmission and single-linkage method assumes the following:
\enumerate{
     \item Each case \eqn{i} is, on average, the infector of \code{R} cases in the population (\eqn{N})
     \item Each case \eqn{i} is allowed to be linked by the linkage criteria to only one other case \eqn{j} in the sampled population (\eqn{M}).
     }
}
\examples{
prob_trans_mtsl(eta=1, chi=1, rho=0.5, M=100, R=1) # Perfect sensitivity and specificity

prob_trans_mtsl(eta=0.99, chi=0.9, rho=1, M=50, R=1)

prob_trans_mtsl(eta=0.99, chi=0.9, rho=0.5, M=100, R=1)
}
\seealso{
Other prob_trans: 
\code{\link{prob_trans_mtml}()},
\code{\link{prob_trans_stsl}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{prob_trans}
