% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-phybreak.R
\name{sample.phybreak}
\alias{sample.phybreak}
\title{Sampling from a phybreak MCMC-chain.}
\usage{
sample.phybreak(phybreak.object, nsample, thin, keepphylo = 0.2)
}
\arguments{
\item{phybreak.object}{An object of class \code{phybreak}.}

\item{nsample}{The number of samples to take.}

\item{thin}{The thinning to use (values after every \code{thin}'th iteration will be included in the posterior). 
Each iteration does one update of all parameters and tree updates with each host as focal host once.}

\item{keepphylo}{The proportion of transmission tree updates keeping the phylotree intact.}
}
\value{
The \code{phybreak}-object used to call the function, including (additional) samples from the posterior.
}
\description{
Function to take (additional) samples from the posterior distribution of a phylogenetic and transmission tree 
  (plus associated parameters), within a \code{phybreak}-object.
}
\examples{
#First create a phybreak-object
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)

MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
MCMCstate <- sample.phybreak(MCMCstate, nsample = 50, thin = 2)
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
\references{
\href{http://dx.doi.org/10.1101/069195}{Klinkenberg et al, on biorXiv}.
}

