% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-current.R
\name{get.phybreak}
\alias{get.mcmc}
\alias{get.parameters}
\alias{get.phybreak}
\alias{get.phylo}
\alias{get.seqdata}
\alias{get.tree}
\title{Accessing a phybreak object}
\usage{
get.tree(phybreak.object)

get.parameters(phybreak.object)

get.mcmc(phybreak.object, thin = 1, nkeep = Inf)

get.phylo(phybreak.object, post.tree = 0, simmap = FALSE)

get.seqdata(phybreak.object)
}
\arguments{
\item{phybreak.object}{An object of class \code{phybreak}.}

\item{thin}{Thinning interval for making the mcmc-object.}

\item{nkeep}{Number of samples to keep in the mcmc-object, counting from tail of the chain.}

\item{post.tree}{The posterior tree sample to choose. If \code{post.tree = 0}, the current state is used.}

\item{simmap}{Whether to include class \code{"simmap"} elements (package \pkg{phytools}), colouring the branches 
on the tree to indicate hosts.}
}
\description{
Accessing a phybreak object
}
\section{Functions}{
\itemize{
\item \code{get.tree}: A \code{data.frame} with current infectors and infection times.

\item \code{get.parameters}: A named vector with all current parameter values.

\item \code{get.mcmc}: An object of class \code{"mcmc"} (package \pkg{coda}), with sampled parameters, 
infection times, and infectors.

\item \code{get.phylo}: Returns an object of class \code{"phylo"} (package \pkg{ape}) and optionally of class 
\code{"simmap"} (package \pkg{phytools}).

\item \code{get.seqdata}: The sequence data in class \code{"phyDat"} (package \pkg{phangorn}).
}}
\examples{
#First build a phybreak-object.
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)
MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
MCMCstate <- sample.phybreak(MCMCstate, nsample = 50, thin = 2)

get.tree(MCMCstate)
get.parameters(MCMCstate)
codaobject <- get.mcmc(MCMCstate, thin = 2)
plot.phylo(get.phylo(MCMCstate))
get.seqdata(MCMCstate)

#function from package phangorn:
phangorn::parsimony(get.phylo(MCMCstate), get.seqdata(MCMCstate))

tree0 <- get.phylo(MCMCstate)
seqdata <- get.seqdata(MCMCstate)
phangorn::pml(tree0, seqdata, rate = 0.75*get.parameters(MCMCstate)["mu"]) 
logLik(MCMCstate, genetic = TRUE, withinhost = FALSE, 
       sampling = FALSE, generation = FALSE) #should give the same result as 'pml'
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
\references{
\href{http://dx.doi.org/10.1101/069195}{Klinkenberg et al, on biorXiv}.
}

