% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreeqc.R
\docType{data}
\name{ex15}
\alias{ex15}
\title{Example 15--1D Transport: Kinetic Biodegradation, Cell Growth, and
Sorption}
\source{
\url{http://wwwbrr.cr.usgs.gov/projects/GWC_coupled/phreeqc}
}
\description{
A test problem for advective-dispersive-reactive transport was
developed by Tebes-Stevens and Valocchi (1997) and Tebes-Stevens and others
(1998). Although based on relatively simple speciation chemistry, the
solution to the problem demonstrates several interacting chemical processes
that are common to many environmental problems: bacterially mediated
degradation of an organic substrate; bacterial cell growth and decay; metal
sorption; and aqueous speciation, including metal-ligand complexation. In
this example, the test problem is solved with PHREEQC, which produces
results almost identical to those of Tebes-Stevens and Valocchi (1997) and
Tebes-Stevens and others (1998). The example can be run using the
\code{\link{phrRunString}} routine.
}
\examples{

# this example takes longer than 5 seconds
phrLoadDatabaseString(ex15.dat)
phrSetOutputStringsOn(TRUE)
\dontrun{phrRunString(ex15)}
phrGetOutputStrings()

}
\references{
\url{https://pubs.usgs.gov/tm/06/a43/pdf/tm6-A43.pdf}
}
\seealso{
Other Examples: 
\code{\link{ex1}},
\code{\link{ex10}},
\code{\link{ex11}},
\code{\link{ex12}},
\code{\link{ex13a}},
\code{\link{ex14}},
\code{\link{ex16}},
\code{\link{ex17}},
\code{\link{ex18}},
\code{\link{ex19}},
\code{\link{ex2}},
\code{\link{ex20a}},
\code{\link{ex21}},
\code{\link{ex22}},
\code{\link{ex3}},
\code{\link{ex4}},
\code{\link{ex5}},
\code{\link{ex6}},
\code{\link{ex7}},
\code{\link{ex8}},
\code{\link{ex9}}
}
\concept{Examples}
\keyword{dataset}
