% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.rm.R
\name{na.omit.source_spct}
\alias{na.omit.source_spct}
\alias{na.omit.response_spct}
\alias{na.omit.filter_spct}
\alias{na.omit.reflector_spct}
\alias{na.omit.cps_spct}
\alias{na.omit.raw_spct}
\alias{na.omit.chroma_spct}
\alias{na.exclude.generic_spct}
\title{Handle Missing Values in Objects}
\usage{
\method{na.omit}{source_spct}(object, na.action = "omit", ...)

\method{na.omit}{response_spct}(object, na.action = "omit", ...)

\method{na.omit}{filter_spct}(object, na.action = "omit", ...)

\method{na.omit}{reflector_spct}(object, na.action = "omit", ...)

\method{na.omit}{cps_spct}(object, na.action = "omit", ...)

\method{na.omit}{raw_spct}(object, na.action = "omit", ...)

\method{na.omit}{chroma_spct}(object, na.action = "omit", ...)

\method{na.exclude}{generic_spct}(object, na.action = "exclude", ...)
}
\arguments{
\item{object}{an R object}

\item{na.action}{character One of "omit" or "exclude"}

\item{...}{further arguments other special methods could require}
}
\description{
These methods are useful for dealing with NAs in e.g., \code{source_spct},
\code{response_spct}, \code{filter_spct} and \code{reflector_spct}.
}
\details{
If \code{na.omit} removes cases, the row numbers of the cases form
  the \code{"na.action"} attribute of the result, of class \code{"omit"}.

  \code{na.exclude} differs from \code{na.omit} only in the class of the
  "na.action" attribute of the result, which is \code{"exclude"}.
}
\note{
\code{na.fail} and \code{na.pass} do not require a specialisation
  for spectral objetcs. R's definitions work as expected with no need to
  override them.
}
\examples{
my_sun.spct <- sun.spct
my_sun.spct[3, "s.e.irrad"] <- NA
my_sun.spct[5, "s.q.irrad"] <- NA
na.omit(my_sun.spct)
na.action(na.omit(my_sun.spct))

}
\seealso{
\code{\link[stats]{na.fail}} and \code{\link[stats]{na.action}}
}
