% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2qmol.multipliers.R
\name{e2qmol_multipliers}
\alias{e2qmol_multipliers}
\title{Calculate energy to quantum (mol) multipliers}
\usage{
e2qmol_multipliers(w.length)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm)}
}
\value{
A numeric array of multipliers
}
\description{
Gives multipliers as a function of wavelength, for converting from energy to
photon (quantum) molar units.
}
\examples{
with(sun.data, e2qmol_multipliers(w.length))

}
\seealso{
Other quantity conversion functions: \code{\link{A2T}},
  \code{\link{T2A}}, \code{\link{as_energy}},
  \code{\link{as_quantum_mol}}, \code{\link{as_quantum}},
  \code{\link{e2quantum_multipliers}}, \code{\link{e2q}},
  \code{\link{q2e}}
}
