% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.new.R
\name{merge.generic_spct}
\alias{merge.generic_spct}
\title{Merge two generic_spct objects}
\usage{
\method{merge}{generic_spct}(x, y, by = "w.length", ...)
}
\arguments{
\item{x}{generic_spct (or derived) objects to be merged}

\item{y}{generic_spct (or derived) objects to be merged}

\item{by}{a vector of shared column names in \code{x} and \code{y} to merge on;
\code{by} defaults to \code{w.length}.}

\item{...}{other arguments passed to \code{dplyr::inner_join()}}
}
\description{
Relatively quick merge of two spct objects based on w.length.
}
\note{
if the class of x and y is the same, it is preserved, but
if it differs \code{generic_spct} is used for the returned value,
except when x and y, are one each of classes reflector_spct and
filter_spct in which case an object_spct is returned.
In the current implementation only wavelengths values shared
by x and y are preserved.
}
\seealso{
\code{\link[dplyr]{join}}
}
